/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.lang.annotation.Annotation;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.annotation.AnnotationListener;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class StreamAnnotationListener
implements AnnotationListener {
    private final ModuleDefineHolder moduleDefineHolder;

    public StreamAnnotationListener(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
    }

    @Override
    public Class<? extends Annotation> annotation() {
        return Stream.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void notify(Class aClass) {
        if (!aClass.isAnnotationPresent(Stream.class)) throw new UnexpectedException("Stream annotation listener could only parse the class present stream annotation.");
        Stream stream = aClass.getAnnotation(Stream.class);
        if (stream.processor().equals(InventoryStreamProcessor.class)) {
            InventoryStreamProcessor.getInstance().create(this.moduleDefineHolder, stream, aClass);
            return;
        } else if (stream.processor().equals(RecordStreamProcessor.class)) {
            RecordStreamProcessor.getInstance().create(this.moduleDefineHolder, stream, aClass);
            return;
        } else if (stream.processor().equals(MetricsStreamProcessor.class)) {
            MetricsStreamProcessor.getInstance().create(this.moduleDefineHolder, stream, aClass);
            return;
        } else {
            if (!stream.processor().equals(TopNStreamProcessor.class)) throw new UnexpectedException("Unknown stream processor.");
            TopNStreamProcessor.getInstance().create(this.moduleDefineHolder, stream, aClass);
        }
    }
}

