/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherManager {
    private static final Logger logger = LoggerFactory.getLogger(DispatcherManager.class);
    private Map<Integer, List<SourceDispatcher>> dispatcherMap = new HashMap<Integer, List<SourceDispatcher>>();

    public void forward(Source source) {
        if (source == null) {
            return;
        }
        List<SourceDispatcher> dispatchers = this.dispatcherMap.get(source.scope());
        if (dispatchers != null) {
            for (SourceDispatcher dispatcher : dispatchers) {
                dispatcher.dispatch(source);
            }
        }
    }

    public void scan() throws IOException, IllegalAccessException, InstantiationException {
        ClassPath classpath = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Type[] genericInterfaces;
            Class aClass = classInfo.load();
            if (aClass.isInterface() || !SourceDispatcher.class.isAssignableFrom(aClass)) continue;
            for (Type genericInterface : genericInterfaces = aClass.getGenericInterfaces()) {
                ParameterizedType anInterface = (ParameterizedType)genericInterface;
                if (!anInterface.getRawType().getTypeName().equals(SourceDispatcher.class.getName())) continue;
                Type[] arguments = anInterface.getActualTypeArguments();
                if (arguments.length != 1) {
                    throw new UnexpectedException("unexpected type argument number, class " + aClass.getName());
                }
                Type argument = arguments[0];
                Object source = ((Class)argument).newInstance();
                if (!Source.class.isAssignableFrom(source.getClass())) {
                    throw new UnexpectedException("unexpected type argument of class " + aClass.getName() + ", should be `org.apache.skywalking.oap.server.core.source.Source`. ");
                }
                Source dispatcherSource = (Source)source;
                SourceDispatcher dispatcher = (SourceDispatcher)aClass.newInstance();
                int scopeId = dispatcherSource.scope();
                List<SourceDispatcher> dispatchers = this.dispatcherMap.get(scopeId);
                if (dispatchers == null) {
                    dispatchers = new ArrayList<SourceDispatcher>();
                    this.dispatcherMap.put(scopeId, dispatchers);
                }
                dispatchers.add(dispatcher);
                logger.info("Dispatcher {} is added into DefaultScopeDefine {}.", (Object)dispatcher.getClass().getName(), (Object)scopeId);
            }
        }
    }
}

