/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm;

import java.util.List;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStandardPersistence
implements AlarmCallback {
    private static final Logger logger = LoggerFactory.getLogger(AlarmStandardPersistence.class);

    @Override
    public void doAlarm(List<AlarmMessage> alarmMessage) {
        alarmMessage.forEach(message -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Alarm message: {}", (Object)message.getAlarmMessage());
            }
            AlarmRecord record = new AlarmRecord();
            record.setScope(message.getScopeId());
            record.setId0(message.getId0());
            record.setId1(message.getId1());
            record.setName(message.getName());
            record.setAlarmMessage(message.getAlarmMessage());
            record.setStartTime(message.getStartTime());
            record.setTimeBucket(TimeBucket.getSecondTimeBucket(message.getStartTime()));
            RecordStreamProcessor.getInstance().in(record);
        });
    }
}

