/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@ScopeDeclaration(id=13, name="Alarm")
@Stream(name="alarm_record", scopeId=13, builder=Builder.class, processor=RecordStreamProcessor.class)
public class AlarmRecord
extends Record {
    public static final String INDEX_NAME = "alarm_record";
    public static final String SCOPE = "scope";
    public static final String NAME = "name";
    public static final String ID0 = "id0";
    public static final String ID1 = "id1";
    public static final String START_TIME = "start_time";
    public static final String ALARM_MESSAGE = "alarm_message";
    @Column(columnName="scope")
    private int scope;
    @Column(columnName="name")
    private String name;
    @Column(columnName="id0")
    private int id0;
    @Column(columnName="id1")
    private int id1;
    @Column(columnName="start_time")
    private long startTime;
    @Column(columnName="alarm_message", matchQuery=true)
    private String alarmMessage;

    @Override
    public String id() {
        return this.getTimeBucket() + "_" + this.scope + "_" + this.id0 + "_" + this.id1;
    }

    public int getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public int getId0() {
        return this.id0;
    }

    public int getId1() {
        return this.id1;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId0(int id0) {
        this.id0 = id0;
    }

    public void setId1(int id1) {
        this.id1 = id1;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    public static class Builder
    implements StorageBuilder<AlarmRecord> {
        @Override
        public Map<String, Object> data2Map(AlarmRecord storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(AlarmRecord.SCOPE, storageData.getScope());
            map.put(AlarmRecord.NAME, storageData.getName());
            map.put(AlarmRecord.ID0, storageData.getId0());
            map.put(AlarmRecord.ID1, storageData.getId1());
            map.put(AlarmRecord.ALARM_MESSAGE, storageData.getAlarmMessage());
            map.put(AlarmRecord.START_TIME, storageData.getStartTime());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        @Override
        public AlarmRecord map2Data(Map<String, Object> dbMap) {
            AlarmRecord record = new AlarmRecord();
            record.setScope(((Number)dbMap.get(AlarmRecord.SCOPE)).intValue());
            record.setName((String)dbMap.get(AlarmRecord.NAME));
            record.setId0(((Number)dbMap.get(AlarmRecord.ID0)).intValue());
            record.setId1(((Number)dbMap.get(AlarmRecord.ID1)).intValue());
            record.setAlarmMessage((String)dbMap.get(AlarmRecord.ALARM_MESSAGE));
            record.setStartTime(((Number)dbMap.get(AlarmRecord.START_TIME)).longValue());
            record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return record;
        }
    }
}

