/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core;

import io.grpc.BindableService;
import java.io.IOException;
import org.apache.skywalking.oap.server.core.CoreModule;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.StreamAnnotationListener;
import org.apache.skywalking.oap.server.core.annotation.AnnotationScan;
import org.apache.skywalking.oap.server.core.cache.CacheUpdateTimer;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.config.ComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.config.DownsamplingConfigService;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.AggregationQueryService;
import org.apache.skywalking.oap.server.core.query.AlarmQueryService;
import org.apache.skywalking.oap.server.core.query.LogQueryService;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.MetricQueryService;
import org.apache.skywalking.oap.server.core.query.TopNRecordsQueryService;
import org.apache.skywalking.oap.server.core.query.TopologyQueryService;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.register.service.EndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.NetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.ServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.ServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.remote.RemoteSenderService;
import org.apache.skywalking.oap.server.core.remote.RemoteServiceHandler;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMapping;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingGetter;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingSetter;
import org.apache.skywalking.oap.server.core.remote.health.HealthCheckServiceHandler;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.server.JettyHandlerRegister;
import org.apache.skywalking.oap.server.core.server.JettyHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.source.SourceReceiverImpl;
import org.apache.skywalking.oap.server.core.storage.PersistenceTimer;
import org.apache.skywalking.oap.server.core.storage.model.IModelGetter;
import org.apache.skywalking.oap.server.core.storage.model.IModelOverride;
import org.apache.skywalking.oap.server.core.storage.model.IModelSetter;
import org.apache.skywalking.oap.server.core.storage.model.StorageModels;
import org.apache.skywalking.oap.server.core.storage.ttl.DataTTLKeeperTimer;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceSetter;
import org.apache.skywalking.oap.server.core.worker.WorkerInstancesService;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.library.server.jetty.JettyServer;

public class CoreModuleProvider
extends ModuleProvider {
    private final CoreModuleConfig moduleConfig = new CoreModuleConfig();
    private GRPCServer grpcServer;
    private JettyServer jettyServer;
    private RemoteClientManager remoteClientManager;
    private final AnnotationScan annotationScan = new AnnotationScan();
    private final StorageModels storageModels;
    private final StreamDataMapping streamDataMapping = new StreamDataMapping();
    private final SourceReceiverImpl receiver;

    public CoreModuleProvider() {
        this.storageModels = new StorageModels();
        this.receiver = new SourceReceiverImpl();
    }

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return CoreModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.moduleConfig;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        AnnotationScan scopeScan = new AnnotationScan();
        scopeScan.registerListener(new DefaultScopeDefine.Listener());
        scopeScan.registerListener(DisableRegister.INSTANCE);
        scopeScan.registerListener(new DisableRegister.SingleDisableScanListener());
        try {
            scopeScan.scan(null);
        }
        catch (IOException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        this.grpcServer = new GRPCServer(this.moduleConfig.getGRPCHost(), this.moduleConfig.getGRPCPort());
        if (this.moduleConfig.getMaxConcurrentCallsPerConnection() > 0) {
            this.grpcServer.setMaxConcurrentCallsPerConnection(this.moduleConfig.getMaxConcurrentCallsPerConnection());
        }
        if (this.moduleConfig.getMaxMessageSize() > 0) {
            this.grpcServer.setMaxMessageSize(this.moduleConfig.getMaxMessageSize());
        }
        this.grpcServer.initialize();
        this.jettyServer = new JettyServer(this.moduleConfig.getRestHost(), this.moduleConfig.getRestPort(), this.moduleConfig.getRestContextPath(), this.moduleConfig.getJettySelectors());
        this.jettyServer.initialize();
        this.registerServiceImplementation(ConfigService.class, new ConfigService(this.moduleConfig));
        this.registerServiceImplementation(DownsamplingConfigService.class, new DownsamplingConfigService(this.moduleConfig.getDownsampling()));
        this.registerServiceImplementation(GRPCHandlerRegister.class, new GRPCHandlerRegisterImpl(this.grpcServer));
        this.registerServiceImplementation(JettyHandlerRegister.class, new JettyHandlerRegisterImpl(this.jettyServer));
        this.registerServiceImplementation(IComponentLibraryCatalogService.class, new ComponentLibraryCatalogService());
        this.registerServiceImplementation(SourceReceiver.class, this.receiver);
        this.registerServiceImplementation(StreamDataMappingGetter.class, this.streamDataMapping);
        this.registerServiceImplementation(StreamDataMappingSetter.class, this.streamDataMapping);
        WorkerInstancesService instancesService = new WorkerInstancesService();
        this.registerServiceImplementation(IWorkerInstanceGetter.class, instancesService);
        this.registerServiceImplementation(IWorkerInstanceSetter.class, instancesService);
        this.registerServiceImplementation(RemoteSenderService.class, new RemoteSenderService(this.getManager()));
        this.registerServiceImplementation(IModelSetter.class, this.storageModels);
        this.registerServiceImplementation(IModelGetter.class, this.storageModels);
        this.registerServiceImplementation(IModelOverride.class, this.storageModels);
        this.registerServiceImplementation(ServiceInventoryCache.class, new ServiceInventoryCache(this.getManager()));
        this.registerServiceImplementation(IServiceInventoryRegister.class, new ServiceInventoryRegister((ModuleDefineHolder)this.getManager()));
        this.registerServiceImplementation(ServiceInstanceInventoryCache.class, new ServiceInstanceInventoryCache(this.getManager()));
        this.registerServiceImplementation(IServiceInstanceInventoryRegister.class, new ServiceInstanceInventoryRegister((ModuleDefineHolder)this.getManager()));
        this.registerServiceImplementation(EndpointInventoryCache.class, new EndpointInventoryCache(this.getManager()));
        this.registerServiceImplementation(IEndpointInventoryRegister.class, new EndpointInventoryRegister((ModuleDefineHolder)this.getManager()));
        this.registerServiceImplementation(NetworkAddressInventoryCache.class, new NetworkAddressInventoryCache(this.getManager()));
        this.registerServiceImplementation(INetworkAddressInventoryRegister.class, new NetworkAddressInventoryRegister((ModuleDefineHolder)this.getManager()));
        this.registerServiceImplementation(TopologyQueryService.class, new TopologyQueryService(this.getManager()));
        this.registerServiceImplementation(MetricQueryService.class, new MetricQueryService(this.getManager()));
        this.registerServiceImplementation(TraceQueryService.class, new TraceQueryService(this.getManager()));
        this.registerServiceImplementation(LogQueryService.class, new LogQueryService(this.getManager()));
        this.registerServiceImplementation(MetadataQueryService.class, new MetadataQueryService(this.getManager()));
        this.registerServiceImplementation(AggregationQueryService.class, new AggregationQueryService(this.getManager()));
        this.registerServiceImplementation(AlarmQueryService.class, new AlarmQueryService(this.getManager()));
        this.registerServiceImplementation(TopNRecordsQueryService.class, new TopNRecordsQueryService(this.getManager()));
        this.annotationScan.registerListener(new StreamAnnotationListener((ModuleDefineHolder)this.getManager()));
        this.remoteClientManager = new RemoteClientManager((ModuleDefineHolder)this.getManager());
        this.registerServiceImplementation(RemoteClientManager.class, this.remoteClientManager);
    }

    public void start() throws ModuleStartException {
        this.grpcServer.addHandler((BindableService)new RemoteServiceHandler((ModuleDefineHolder)this.getManager()));
        this.grpcServer.addHandler((BindableService)new HealthCheckServiceHandler());
        this.remoteClientManager.start();
        try {
            this.receiver.scan();
            this.annotationScan.scan(() -> {});
            this.streamDataMapping.init();
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ModuleStartException {
        try {
            this.grpcServer.start();
            this.jettyServer.start();
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        if (CoreModuleConfig.Role.Mixed.name().equalsIgnoreCase(this.moduleConfig.getRole()) || CoreModuleConfig.Role.Aggregator.name().equalsIgnoreCase(this.moduleConfig.getRole())) {
            RemoteInstance gRPCServerInstance = new RemoteInstance(new Address(this.moduleConfig.getGRPCHost(), this.moduleConfig.getGRPCPort(), true));
            ((ClusterRegister)this.getManager().find("cluster").provider().getService(ClusterRegister.class)).registerRemote(gRPCServerInstance);
        }
        PersistenceTimer.INSTANCE.start(this.getManager());
        if (this.moduleConfig.isEnableDataKeeperExecutor()) {
            DataTTLKeeperTimer.INSTANCE.start(this.getManager());
        }
        CacheUpdateTimer.INSTANCE.start(this.getManager());
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "configuration"};
    }
}

