/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.istio.telemetry.provider;

import com.google.common.base.Joiner;
import com.google.protobuf.Timestamp;
import io.grpc.stub.StreamObserver;
import io.istio.HandleMetricServiceGrpc;
import io.istio.IstioMetricProto;
import io.istio.api.mixer.adapter.model.v1beta1.ReportProto;
import io.istio.api.policy.v1beta1.TypeProto;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.network.common.DetectPoint;
import org.apache.skywalking.apm.network.servicemesh.Protocol;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IstioTelemetryGRPCHandler
extends HandleMetricServiceGrpc.HandleMetricServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(IstioTelemetryGRPCHandler.class);
    private static final Joiner JOINER = Joiner.on((String)".");
    private CounterMetrics counter;
    private HistogramMetrics histogram;

    public IstioTelemetryGRPCHandler(ModuleManager moduleManager) {
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.counter = metricsCreator.createCounter("istio_mesh_grpc_in_count", "The count of istio service mesh telemetry", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.histogram = metricsCreator.createHistogramMetric("istio_mesh_grpc_in_latency", "The process latency of istio service mesh telemetry", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMetric(IstioMetricProto.HandleMetricRequest request, StreamObserver<ReportProto.ReportResult> responseObserver) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received msg {}", (Object)request);
        }
        for (IstioMetricProto.InstanceMsg i : request.getInstancesList()) {
            this.counter.inc();
            HistogramMetrics.Timer timer = this.histogram.createTimer();
            try {
                Protocol netProtocol;
                String endpoint;
                String requestMethod = this.string(i, "requestMethod");
                String requestPath = this.string(i, "requestPath");
                String requestScheme = this.string(i, "requestScheme");
                long responseCode = this.int64(i, "responseCode");
                String reporter = this.string(i, "reporter");
                String protocol = this.string(i, "apiProtocol");
                boolean status = true;
                if (protocol.equals("http") || protocol.equals("https") || requestScheme.equals("http") || requestScheme.equals("https")) {
                    endpoint = requestScheme + "/" + requestMethod + "/" + requestPath;
                    status = responseCode >= 200L && responseCode < 400L;
                    netProtocol = Protocol.HTTP;
                } else {
                    endpoint = protocol + "/" + requestPath;
                    netProtocol = Protocol.gRPC;
                }
                Instant requestTime = this.time(i, "requestTime");
                Instant responseTime = this.time(i, "responseTime");
                int latency = Math.toIntExact(Duration.between(requestTime, responseTime).toMillis());
                DetectPoint detectPoint = reporter.equals("source") ? DetectPoint.client : DetectPoint.server;
                String sourceServiceName = this.has(i, "sourceNamespace") ? JOINER.join((Object)this.string(i, "sourceService"), (Object)this.string(i, "sourceNamespace"), new Object[0]) : this.string(i, "sourceService");
                String destServiceName = this.has(i, "destinationNamespace") ? JOINER.join((Object)this.string(i, "destinationService"), (Object)this.string(i, "destinationNamespace"), new Object[0]) : this.string(i, "destinationService");
                ServiceMeshMetric metrics = ServiceMeshMetric.newBuilder().setStartTime(requestTime.toEpochMilli()).setEndTime(responseTime.toEpochMilli()).setSourceServiceName(sourceServiceName).setSourceServiceInstance(this.string(i, "sourceUID")).setDestServiceName(destServiceName).setDestServiceInstance(this.string(i, "destinationUID")).setEndpoint(endpoint).setLatency(latency).setResponseCode(Math.toIntExact(responseCode)).setStatus(status).setProtocol(netProtocol).setDetectPoint(detectPoint).build();
                logger.debug("Transformed metrics {}", (Object)metrics);
                TelemetryDataDispatcher.preProcess((ServiceMeshMetric)metrics);
            }
            finally {
                timer.finish();
            }
        }
        responseObserver.onNext((Object)ReportProto.ReportResult.newBuilder().build());
        responseObserver.onCompleted();
    }

    private String string(IstioMetricProto.InstanceMsg instanceMsg, String key) {
        Map map = instanceMsg.getDimensionsMap();
        this.assertDimension(map, key);
        return ((TypeProto.Value)map.get(key)).getStringValue();
    }

    private long int64(IstioMetricProto.InstanceMsg instanceMsg, String key) {
        Map map = instanceMsg.getDimensionsMap();
        this.assertDimension(map, key);
        return ((TypeProto.Value)map.get(key)).getInt64Value();
    }

    private Instant time(IstioMetricProto.InstanceMsg instanceMsg, String key) {
        Map map = instanceMsg.getDimensionsMap();
        this.assertDimension(map, key);
        Timestamp timestamp = ((TypeProto.Value)map.get(key)).getTimestampValue().getValue();
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    private void assertDimension(Map<String, TypeProto.Value> map, String key) {
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Lack dimension %s", key));
        }
    }

    private boolean has(IstioMetricProto.InstanceMsg instanceMsg, String key) {
        Map map = instanceMsg.getDimensionsMap();
        return map.containsKey(key);
    }
}

