/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.opencensus.trace;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.skywalking.apm.dependencies.com.google.common.annotations.VisibleForTesting;
import org.apache.skywalking.apm.dependencies.io.opencensus.common.Clock;
import org.apache.skywalking.apm.dependencies.io.opencensus.internal.Provider;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.TraceComponent;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.Tracer;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.config.TraceConfig;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.export.ExportComponent;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.propagation.PropagationComponent;

public final class Tracing {
    private static final Logger logger = Logger.getLogger(Tracing.class.getName());
    private static final TraceComponent traceComponent = Tracing.loadTraceComponent(TraceComponent.class.getClassLoader());

    public static Tracer getTracer() {
        return traceComponent.getTracer();
    }

    public static PropagationComponent getPropagationComponent() {
        return traceComponent.getPropagationComponent();
    }

    public static Clock getClock() {
        return traceComponent.getClock();
    }

    public static ExportComponent getExportComponent() {
        return traceComponent.getExportComponent();
    }

    public static TraceConfig getTraceConfig() {
        return traceComponent.getTraceConfig();
    }

    @VisibleForTesting
    static TraceComponent loadTraceComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("org.apache.skywalking.apm.dependencies.io.opencensus.impl.trace.TraceComponentImpl", true, classLoader), TraceComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for TraceComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("org.apache.skywalking.apm.dependencies.io.opencensus.impllite.trace.TraceComponentImplLite", true, classLoader), TraceComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for TraceComponent, now using default implementation for TraceComponent.", e2);
                return TraceComponent.newNoopTraceComponent();
            }
        }
    }

    private Tracing() {
    }
}

