/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.opencensus.trace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Preconditions;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.AttributeValue;
import org.apache.skywalking.apm.dependencies.io.opencensus.trace.AutoValue_Annotation;

@Immutable
public abstract class Annotation {
    private static final Map<String, AttributeValue> EMPTY_ATTRIBUTES = Collections.unmodifiableMap(Collections.emptyMap());

    public static Annotation fromDescription(String description) {
        return new AutoValue_Annotation(description, EMPTY_ATTRIBUTES);
    }

    public static Annotation fromDescriptionAndAttributes(String description, Map<String, AttributeValue> attributes) {
        return new AutoValue_Annotation(description, Collections.unmodifiableMap(new HashMap<String, AttributeValue>(Preconditions.checkNotNull(attributes, "attributes"))));
    }

    public abstract String getDescription();

    public abstract Map<String, AttributeValue> getAttributes();

    Annotation() {
    }
}

