/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.netty.handler.ssl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.apache.skywalking.apm.dependencies.io.netty.buffer.ByteBufAllocator;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.OpenSslKeyMaterial;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.PemEncoded;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.PemX509Certificate;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.apache.skywalking.apm.dependencies.io.netty.internal.tcnative.SSL;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager keyManager, String password) {
        this.keyManager = keyManager;
        this.password = password;
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        PrivateKey key = this.keyManager.getPrivateKey(alias);
        PemEncoded encoded = PemX509Certificate.toPEM(allocator, true, certificates);
        long chainBio = 0L;
        long pkeyBio = 0L;
        long chain = 0L;
        long pkey = 0L;
        try {
            chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded.retain());
            pkeyBio = ReferenceCountedOpenSslContext.toBIO(allocator, key);
            chain = SSL.parseX509Chain(chainBio);
            pkey = key == null ? 0L : SSL.parsePrivateKey(pkeyBio, this.password);
            OpenSslKeyMaterial keyMaterial = new OpenSslKeyMaterial(chain, pkey);
            chain = 0L;
            pkey = 0L;
            OpenSslKeyMaterial openSslKeyMaterial = keyMaterial;
            return openSslKeyMaterial;
        }
        finally {
            SSL.freeBIO(chainBio);
            SSL.freeBIO(pkeyBio);
            if (chain != 0L) {
                SSL.freeX509Chain(chain);
            }
            if (pkey != 0L) {
                SSL.freePrivateKey(pkey);
            }
            encoded.release();
        }
    }

    void destroy() {
    }
}

