/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.netty.handler.codec.http.websocketx;

import java.util.List;
import org.apache.skywalking.apm.dependencies.io.netty.channel.ChannelHandlerContext;
import org.apache.skywalking.apm.dependencies.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.skywalking.apm.dependencies.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.apache.skywalking.apm.dependencies.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.apache.skywalking.apm.dependencies.io.netty.handler.codec.http.websocketx.WebSocketFrame;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame> {
    private final boolean dropPongFrames;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean dropPongFrames) {
        this.dropPongFrames = dropPongFrames;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.channel().writeAndFlush(new PongWebSocketFrame(frame.content()));
            return;
        }
        if (frame instanceof PongWebSocketFrame && this.dropPongFrames) {
            return;
        }
        out.add(frame.retain());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
        ctx.close();
    }
}

