/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.grpc.internal;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.skywalking.apm.dependencies.com.google.common.annotations.VisibleForTesting;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Preconditions;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Verify;
import org.apache.skywalking.apm.dependencies.io.grpc.Attributes;
import org.apache.skywalking.apm.dependencies.io.grpc.EquivalentAddressGroup;
import org.apache.skywalking.apm.dependencies.io.grpc.NameResolver;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.GrpcAttributes;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.JsonParser;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.PairSocketAddress;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.ProxyDetector;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.ProxyParameters;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.ServiceConfigUtil;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.SharedResourceHolder;

final class DnsNameResolver
extends NameResolver {
    private static final Logger logger = Logger.getLogger(DnsNameResolver.class.getName());
    private static final String SERVICE_CONFIG_CHOICE_CLIENT_LANGUAGE_KEY = "clientLanguage";
    private static final String SERVICE_CONFIG_CHOICE_PERCENTAGE_KEY = "percentage";
    private static final String SERVICE_CONFIG_CHOICE_CLIENT_HOSTNAME_KEY = "clientHostname";
    private static final String SERVICE_CONFIG_CHOICE_SERVICE_CONFIG_KEY = "serviceConfig";
    static final String SERVICE_CONFIG_PREFIX = "_grpc_config=";
    private static final Set<String> SERVICE_CONFIG_CHOICE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("clientLanguage", "percentage", "clientHostname", "serviceConfig")));
    private static final String SERVICE_CONFIG_NAME_PREFIX = "_grpc_config.";
    private static final String GRPCLB_NAME_PREFIX = "_grpclb._tcp.";
    private static final String JNDI_PROPERTY = System.getProperty("org.apache.skywalking.apm.dependencies.io.grpc.internal.DnsNameResolverProvider.enable_jndi", "true");
    private static final String JNDI_SRV_PROPERTY = System.getProperty("org.apache.skywalking.apm.dependencies.io.grpc.internal.DnsNameResolverProvider.enable_grpclb", "false");
    private static final String JNDI_TXT_PROPERTY = System.getProperty("org.apache.skywalking.apm.dependencies.io.grpc.internal.DnsNameResolverProvider.enable_service_config", "false");
    @VisibleForTesting
    static boolean enableJndi = Boolean.parseBoolean(JNDI_PROPERTY);
    @VisibleForTesting
    static boolean enableSrv = Boolean.parseBoolean(JNDI_SRV_PROPERTY);
    @VisibleForTesting
    static boolean enableTxt = Boolean.parseBoolean(JNDI_TXT_PROPERTY);
    private static final ResourceResolverFactory resourceResolverFactory = DnsNameResolver.getResourceResolverFactory(DnsNameResolver.class.getClassLoader());
    @VisibleForTesting
    final ProxyDetector proxyDetector;
    private static String localHostname;
    private final Random random = new Random();
    private volatile AddressResolver addressResolver = JdkAddressResolver.INSTANCE;
    private final AtomicReference<ResourceResolver> resourceResolver = new AtomicReference();
    private final String authority;
    private final String host;
    private final int port;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private ExecutorService executor;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            DnsNameResolver dnsNameResolver = DnsNameResolver.this;
            synchronized (dnsNameResolver) {
                if (DnsNameResolver.this.shutdown) {
                    return;
                }
                savedListener = DnsNameResolver.this.listener;
                DnsNameResolver.this.resolving = true;
            }
            try {
                ResolutionResults resolutionResults;
                ProxyParameters proxy;
                InetSocketAddress destination = InetSocketAddress.createUnresolved(DnsNameResolver.this.host, DnsNameResolver.this.port);
                try {
                    proxy = DnsNameResolver.this.proxyDetector.proxyFor(destination);
                }
                catch (IOException e) {
                    savedListener.onError(Status.UNAVAILABLE.withDescription("Unable to resolve host " + DnsNameResolver.this.host).withCause(e));
                    DnsNameResolver dnsNameResolver2 = DnsNameResolver.this;
                    synchronized (dnsNameResolver2) {
                        DnsNameResolver.this.resolving = false;
                    }
                    return;
                }
                if (proxy != null) {
                    EquivalentAddressGroup server = new EquivalentAddressGroup(new PairSocketAddress(destination, Attributes.newBuilder().set(ProxyDetector.PROXY_PARAMS_KEY, proxy).build()));
                    savedListener.onAddresses(Collections.singletonList(server), Attributes.EMPTY);
                    return;
                }
                try {
                    ResourceResolver resourceResolver = null;
                    if (enableJndi) {
                        resourceResolver = DnsNameResolver.this.getResourceResolver();
                    }
                    resolutionResults = DnsNameResolver.resolveAll(DnsNameResolver.this.addressResolver, resourceResolver, enableSrv, enableTxt, DnsNameResolver.this.host);
                }
                catch (Exception e) {
                    savedListener.onError(Status.UNAVAILABLE.withDescription("Unable to resolve host " + DnsNameResolver.this.host).withCause(e));
                    DnsNameResolver dnsNameResolver3 = DnsNameResolver.this;
                    synchronized (dnsNameResolver3) {
                        DnsNameResolver.this.resolving = false;
                    }
                    return;
                }
                ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>();
                for (InetAddress inetAddress : resolutionResults.addresses) {
                    servers.add(new EquivalentAddressGroup(new InetSocketAddress(inetAddress, DnsNameResolver.this.port)));
                }
                servers.addAll(resolutionResults.balancerAddresses);
                Attributes.Builder attrs = Attributes.newBuilder();
                if (!resolutionResults.txtRecords.isEmpty()) {
                    void var7_18;
                    Object var7_17 = null;
                    try {
                        for (Map<String, Object> possibleConfig : DnsNameResolver.parseTxtResults(resolutionResults.txtRecords)) {
                            try {
                                Map<String, Object> map = DnsNameResolver.maybeChooseServiceConfig(possibleConfig, DnsNameResolver.this.random, DnsNameResolver.getLocalHostname());
                            }
                            catch (RuntimeException e) {
                                logger.log(Level.WARNING, "Bad service config choice " + possibleConfig, e);
                            }
                            if (var7_18 == null) continue;
                            break;
                        }
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.WARNING, "Can't parse service Configs", e);
                    }
                    if (var7_18 != null) {
                        attrs.set(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG, var7_18);
                    }
                } else {
                    logger.log(Level.FINE, "No TXT records found for {0}", new Object[]{DnsNameResolver.this.host});
                }
                savedListener.onAddresses(servers, attrs.build());
            }
            finally {
                DnsNameResolver dnsNameResolver2 = DnsNameResolver.this;
                synchronized (dnsNameResolver2) {
                    DnsNameResolver.this.resolving = false;
                }
            }
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DnsNameResolver(@Nullable String nsAuthority, String name, Attributes params, SharedResourceHolder.Resource<ExecutorService> executorResource, ProxyDetector proxyDetector) {
        this.executorResource = executorResource;
        URI nameUri = URI.create("//" + name);
        this.authority = Preconditions.checkNotNull(nameUri.getAuthority(), "nameUri (%s) doesn't have an authority", (Object)nameUri);
        this.host = Preconditions.checkNotNull(nameUri.getHost(), "host");
        if (nameUri.getPort() == -1) {
            Integer defaultPort = params.get(NameResolver.Factory.PARAMS_DEFAULT_PORT);
            if (defaultPort == null) throw new IllegalArgumentException("name '" + name + "' doesn't contain a port, and default port is not set in params");
            this.port = defaultPort;
        } else {
            this.port = nameUri.getPort();
        }
        this.proxyDetector = proxyDetector;
    }

    @Override
    public final String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState(this.listener == null, "already started");
        this.executor = SharedResourceHolder.get(this.executorResource);
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    @Override
    public final synchronized void refresh() {
        Preconditions.checkState(this.listener != null, "not started");
        this.resolve();
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static ResolutionResults resolveAll(AddressResolver addressResolver, @Nullable ResourceResolver resourceResolver, boolean requestSrvRecords, boolean requestTxtRecords, String name) {
        List<Object> addresses = Collections.emptyList();
        Exception addressesException = null;
        List<EquivalentAddressGroup> balancerAddresses = Collections.emptyList();
        Exception balancerAddressesException = null;
        List<String> txtRecords = Collections.emptyList();
        Exception txtRecordsException = null;
        try {
            addresses = addressResolver.resolveAddress(name);
        }
        catch (Exception e) {
            addressesException = e;
        }
        if (resourceResolver != null) {
            if (requestSrvRecords) {
                try {
                    balancerAddresses = resourceResolver.resolveSrv(addressResolver, GRPCLB_NAME_PREFIX + name);
                }
                catch (Exception e) {
                    balancerAddressesException = e;
                }
            }
            if (requestTxtRecords) {
                boolean dontResolveTxt;
                boolean balancerLookupFailedOrNotAttempted = !requestSrvRecords || balancerAddressesException != null;
                boolean bl = dontResolveTxt = addressesException != null && balancerLookupFailedOrNotAttempted;
                if (!dontResolveTxt) {
                    try {
                        txtRecords = resourceResolver.resolveTxt(SERVICE_CONFIG_NAME_PREFIX + name);
                    }
                    catch (Exception e) {
                        txtRecordsException = e;
                    }
                }
            }
        }
        try {
            if (addressesException != null && balancerAddressesException != null) {
                throw new RuntimeException(addressesException);
            }
        }
        finally {
            if (addressesException != null) {
                logger.log(Level.FINE, "Address resolution failure", addressesException);
            }
            if (balancerAddressesException != null) {
                logger.log(Level.FINE, "Balancer resolution failure", balancerAddressesException);
            }
            if (txtRecordsException != null) {
                logger.log(Level.FINE, "ServiceConfig resolution failure", txtRecordsException);
            }
        }
        return new ResolutionResults(addresses, txtRecords, balancerAddresses);
    }

    @VisibleForTesting
    static List<Map<String, Object>> parseTxtResults(List<String> txtRecords) {
        ArrayList<Map<String, Object>> serviceConfigs = new ArrayList<Map<String, Object>>();
        for (String txtRecord : txtRecords) {
            if (txtRecord.startsWith(SERVICE_CONFIG_PREFIX)) {
                List choices;
                try {
                    Object rawChoices = JsonParser.parse(txtRecord.substring(SERVICE_CONFIG_PREFIX.length()));
                    if (!(rawChoices instanceof List)) {
                        throw new IOException("wrong type " + rawChoices);
                    }
                    List listChoices = (List)rawChoices;
                    for (Object obj : listChoices) {
                        if (obj instanceof Map) continue;
                        throw new IOException("wrong element type " + rawChoices);
                    }
                    choices = listChoices;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Bad service config: " + txtRecord, e);
                    continue;
                }
                serviceConfigs.addAll(choices);
                continue;
            }
            logger.log(Level.FINE, "Ignoring non service config {0}", new Object[]{txtRecord});
        }
        return serviceConfigs;
    }

    @Nullable
    private static final Double getPercentageFromChoice(Map<String, Object> serviceConfigChoice) {
        if (!serviceConfigChoice.containsKey(SERVICE_CONFIG_CHOICE_PERCENTAGE_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getDouble(serviceConfigChoice, SERVICE_CONFIG_CHOICE_PERCENTAGE_KEY);
    }

    @Nullable
    private static final List<String> getClientLanguagesFromChoice(Map<String, Object> serviceConfigChoice) {
        if (!serviceConfigChoice.containsKey(SERVICE_CONFIG_CHOICE_CLIENT_LANGUAGE_KEY)) {
            return null;
        }
        return ServiceConfigUtil.checkStringList(ServiceConfigUtil.getList(serviceConfigChoice, SERVICE_CONFIG_CHOICE_CLIENT_LANGUAGE_KEY));
    }

    @Nullable
    private static final List<String> getHostnamesFromChoice(Map<String, Object> serviceConfigChoice) {
        if (!serviceConfigChoice.containsKey(SERVICE_CONFIG_CHOICE_CLIENT_HOSTNAME_KEY)) {
            return null;
        }
        return ServiceConfigUtil.checkStringList(ServiceConfigUtil.getList(serviceConfigChoice, SERVICE_CONFIG_CHOICE_CLIENT_HOSTNAME_KEY));
    }

    @Nullable
    @VisibleForTesting
    static Map<String, Object> maybeChooseServiceConfig(Map<String, Object> choice, Random random, String hostname) {
        List<String> clientHostnames;
        Double percentage;
        for (Map.Entry<String, Object> entry : choice.entrySet()) {
            Verify.verify(SERVICE_CONFIG_CHOICE_KEYS.contains(entry.getKey()), "Bad key: %s", entry);
        }
        List<String> clientLanguages = DnsNameResolver.getClientLanguagesFromChoice(choice);
        if (clientLanguages != null && !clientLanguages.isEmpty()) {
            boolean javaPresent = false;
            for (String lang : clientLanguages) {
                if (!"java".equalsIgnoreCase(lang)) continue;
                javaPresent = true;
                break;
            }
            if (!javaPresent) {
                return null;
            }
        }
        if ((percentage = DnsNameResolver.getPercentageFromChoice(choice)) != null) {
            int pct = percentage.intValue();
            Verify.verify(pct >= 0 && pct <= 100, "Bad percentage: %s", percentage);
            if (random.nextInt(100) >= pct) {
                return null;
            }
        }
        if ((clientHostnames = DnsNameResolver.getHostnamesFromChoice(choice)) != null && !clientHostnames.isEmpty()) {
            boolean hostnamePresent = false;
            for (String clientHostname : clientHostnames) {
                if (!clientHostname.equals(hostname)) continue;
                hostnamePresent = true;
                break;
            }
            if (!hostnamePresent) {
                return null;
            }
        }
        return ServiceConfigUtil.getObject(choice, SERVICE_CONFIG_CHOICE_SERVICE_CONFIG_KEY);
    }

    @VisibleForTesting
    void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    @Nullable
    private ResourceResolver getResourceResolver() {
        ResourceResolver rr = this.resourceResolver.get();
        if (rr == null && resourceResolverFactory != null) {
            assert (resourceResolverFactory.unavailabilityCause() == null);
            rr = resourceResolverFactory.newResourceResolver();
        }
        return rr;
    }

    @Nullable
    @VisibleForTesting
    static ResourceResolverFactory getResourceResolverFactory(ClassLoader loader) {
        ResourceResolverFactory rrf;
        Constructor<ResourceResolverFactory> jndiCtor;
        Class<ResourceResolverFactory> jndiClazz;
        try {
            jndiClazz = Class.forName("org.apache.skywalking.apm.dependencies.io.grpc.internal.JndiResourceResolverFactory", true, loader).asSubclass(ResourceResolverFactory.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find JndiResourceResolverFactory, skipping.", e);
            return null;
        }
        try {
            jndiCtor = jndiClazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Can't find JndiResourceResolverFactory ctor, skipping.", e);
            return null;
        }
        try {
            rrf = jndiCtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Can't construct JndiResourceResolverFactory, skipping.", e);
            return null;
        }
        if (rrf.unavailabilityCause() != null) {
            logger.log(Level.FINE, "JndiResourceResolverFactory not available, skipping.", rrf.unavailabilityCause());
        }
        return rrf;
    }

    private static String getLocalHostname() {
        if (localHostname == null) {
            try {
                localHostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localHostname;
    }

    static interface ResourceResolver {
        public List<String> resolveTxt(String var1) throws Exception;

        public List<EquivalentAddressGroup> resolveSrv(AddressResolver var1, String var2) throws Exception;
    }

    private static enum JdkAddressResolver implements AddressResolver
    {
        INSTANCE;


        @Override
        public List<InetAddress> resolveAddress(String host) throws UnknownHostException {
            return Collections.unmodifiableList(Arrays.asList(InetAddress.getAllByName(host)));
        }
    }

    static interface AddressResolver {
        public List<InetAddress> resolveAddress(String var1) throws Exception;
    }

    static interface ResourceResolverFactory {
        @Nullable
        public ResourceResolver newResourceResolver();

        @Nullable
        public Throwable unavailabilityCause();
    }

    @VisibleForTesting
    static final class ResolutionResults {
        final List<? extends InetAddress> addresses;
        final List<String> txtRecords;
        final List<EquivalentAddressGroup> balancerAddresses;

        ResolutionResults(List<? extends InetAddress> addresses, List<String> txtRecords, List<EquivalentAddressGroup> balancerAddresses) {
            this.addresses = Collections.unmodifiableList(Preconditions.checkNotNull(addresses, "addresses"));
            this.txtRecords = Collections.unmodifiableList(Preconditions.checkNotNull(txtRecords, "txtRecords"));
            this.balancerAddresses = Collections.unmodifiableList(Preconditions.checkNotNull(balancerAddresses, "balancerAddresses"));
        }
    }
}

