/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.grpc.internal;

import java.io.Closeable;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Objects;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Preconditions;
import org.apache.skywalking.apm.dependencies.io.grpc.Attributes;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.ConnectionClientTransport;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.ProxyParameters;

public interface ClientTransportFactory
extends Closeable {
    public ConnectionClientTransport newClientTransport(SocketAddress var1, ClientTransportOptions var2);

    public ScheduledExecutorService getScheduledExecutorService();

    @Override
    public void close();

    public static final class ClientTransportOptions {
        private String authority = "unknown-authority";
        private Attributes eagAttributes = Attributes.EMPTY;
        @Nullable
        private String userAgent;
        @Nullable
        private ProxyParameters proxyParameters;

        public String getAuthority() {
            return this.authority;
        }

        public ClientTransportOptions setAuthority(String authority) {
            this.authority = Preconditions.checkNotNull(authority, "authority");
            return this;
        }

        public Attributes getEagAttributes() {
            return this.eagAttributes;
        }

        public ClientTransportOptions setEagAttributes(Attributes eagAttributes) {
            Preconditions.checkNotNull(eagAttributes, "eagAttributes");
            this.eagAttributes = eagAttributes;
            return this;
        }

        @Nullable
        public String getUserAgent() {
            return this.userAgent;
        }

        public ClientTransportOptions setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Nullable
        public ProxyParameters getProxyParameters() {
            return this.proxyParameters;
        }

        public ClientTransportOptions setProxyParameters(@Nullable ProxyParameters proxyParameters) {
            this.proxyParameters = proxyParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hashCode(this.authority, this.eagAttributes, this.userAgent, this.proxyParameters);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClientTransportOptions)) {
                return false;
            }
            ClientTransportOptions that = (ClientTransportOptions)o;
            return this.authority.equals(that.authority) && this.eagAttributes.equals(that.eagAttributes) && Objects.equal(this.userAgent, that.userAgent) && Objects.equal(this.proxyParameters, that.proxyParameters);
        }
    }
}

