/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.commons.datacarrier.consumer;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.commons.datacarrier.buffer.Buffer;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;

public class ConsumerThread<T>
extends Thread {
    private volatile boolean running;
    private IConsumer<T> consumer;
    private List<DataSource> dataSources;
    private long consumeCycle;

    ConsumerThread(String threadName, IConsumer<T> consumer, long consumeCycle) {
        super(threadName);
        this.consumer = consumer;
        this.running = false;
        this.dataSources = new LinkedList<DataSource>();
        this.consumeCycle = consumeCycle;
    }

    void addDataSource(Buffer<T> sourceBuffer, int start, int end) {
        this.dataSources.add(new DataSource(sourceBuffer, start, end));
    }

    void addDataSource(Buffer<T> sourceBuffer) {
        this.dataSources.add(new DataSource(sourceBuffer, 0, sourceBuffer.getBufferSize()));
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            boolean hasData = this.consume();
            if (hasData) continue;
            try {
                Thread.sleep(this.consumeCycle);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.consume();
        this.consumer.onExit();
    }

    private boolean consume() {
        boolean hasData = false;
        LinkedList consumeList = new LinkedList();
        for (DataSource dataSource : this.dataSources) {
            LinkedList data = dataSource.obtain();
            if (data.size() == 0) continue;
            consumeList.addAll(data);
            hasData = true;
        }
        if (consumeList.size() > 0) {
            try {
                this.consumer.consume(consumeList);
            }
            catch (Throwable t) {
                this.consumer.onError(consumeList, t);
            }
        }
        return hasData;
    }

    void shutdown() {
        this.running = false;
    }

    class DataSource {
        private Buffer<T> sourceBuffer;
        private int start;
        private int end;

        DataSource(Buffer<T> sourceBuffer, int start, int end) {
            this.sourceBuffer = sourceBuffer;
            this.start = start;
            this.end = end;
        }

        LinkedList<T> obtain() {
            return this.sourceBuffer.obtain(this.start, this.end);
        }
    }
}

