/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.sampling;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class SamplingService
implements BootService {
    private static final ILog logger = LogManager.getLogger(SamplingService.class);
    private volatile boolean on = false;
    private volatile AtomicInteger samplingFactorHolder;
    private volatile ScheduledFuture<?> scheduledFuture;

    @Override
    public void prepare() throws Throwable {
    }

    @Override
    public void boot() throws Throwable {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (Config.Agent.SAMPLE_N_PER_3_SECS > 0) {
            this.on = true;
            this.resetSamplingFactor();
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("SamplingService"));
            this.scheduledFuture = service.scheduleAtFixedRate(new RunnableWithExceptionProtection(new Runnable(){

                @Override
                public void run() {
                    SamplingService.this.resetSamplingFactor();
                }
            }, new RunnableWithExceptionProtection.CallbackWhenException(){

                @Override
                public void handle(Throwable t) {
                    logger.error("unexpected exception.", t);
                }
            }), 0L, 3L, TimeUnit.SECONDS);
            logger.debug("Agent sampling mechanism started. Sample {} traces in 3 seconds.", Config.Agent.SAMPLE_N_PER_3_SECS);
        }
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public boolean trySampling() {
        if (this.on) {
            int factor = this.samplingFactorHolder.get();
            if (factor < Config.Agent.SAMPLE_N_PER_3_SECS) {
                boolean success = this.samplingFactorHolder.compareAndSet(factor, factor + 1);
                return success;
            }
            return false;
        }
        return true;
    }

    public void forceSampled() {
        if (this.on) {
            this.samplingFactorHolder.incrementAndGet();
        }
    }

    private void resetSamplingFactor() {
        this.samplingFactorHolder = new AtomicInteger(0);
    }
}

