/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.io.File;
import javax.net.ssl.SSLException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.remote.ChannelBuilder;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.GrpcSslContexts;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.NegotiationType;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.NettyChannelBuilder;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.SslContextBuilder;

public class TLSChannelBuilder
implements ChannelBuilder<NettyChannelBuilder> {
    private static String CA_FILE_NAME = "ca" + Constants.PATH_SEPARATOR + "ca.crt";

    @Override
    public NettyChannelBuilder build(NettyChannelBuilder managedChannelBuilder) throws AgentPackageNotFoundException, SSLException {
        File caFile = new File(AgentPackagePath.getPath(), CA_FILE_NAME);
        if (caFile.exists() && caFile.isFile()) {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            builder.trustManager(caFile);
            managedChannelBuilder = managedChannelBuilder.negotiationType(NegotiationType.TLS).sslContext(builder.build());
        }
        return managedChannelBuilder;
    }
}

