/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.RemoteDownstreamConfig;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.agent.core.dictionary.EndpointNameDictionary;
import org.apache.skywalking.apm.agent.core.dictionary.NetworkAddressDictionary;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.os.OSUtil;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.network.common.KeyIntValuePair;
import org.apache.skywalking.apm.network.register.v2.RegisterGrpc;
import org.apache.skywalking.apm.network.register.v2.Service;
import org.apache.skywalking.apm.network.register.v2.ServiceInstance;
import org.apache.skywalking.apm.network.register.v2.ServiceInstancePingGrpc;
import org.apache.skywalking.apm.network.register.v2.ServiceInstancePingPkg;
import org.apache.skywalking.apm.network.register.v2.ServiceInstanceRegisterMapping;
import org.apache.skywalking.apm.network.register.v2.ServiceInstances;
import org.apache.skywalking.apm.network.register.v2.ServiceRegisterMapping;
import org.apache.skywalking.apm.network.register.v2.Services;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.apm.util.StringUtil;

@DefaultImplementor
public class ServiceAndEndpointRegisterClient
implements BootService,
Runnable,
GRPCChannelListener {
    private static final ILog logger = LogManager.getLogger(ServiceAndEndpointRegisterClient.class);
    private static String INSTANCE_UUID;
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private volatile RegisterGrpc.RegisterBlockingStub registerBlockingStub;
    private volatile ServiceInstancePingGrpc.ServiceInstancePingBlockingStub serviceInstancePingStub;
    private volatile ScheduledFuture<?> applicationRegisterFuture;

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
            this.registerBlockingStub = RegisterGrpc.newBlockingStub(channel);
            this.serviceInstancePingStub = ServiceInstancePingGrpc.newBlockingStub(channel);
        } else {
            this.registerBlockingStub = null;
            this.serviceInstancePingStub = null;
        }
        this.status = status;
    }

    @Override
    public void prepare() throws Throwable {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
        INSTANCE_UUID = StringUtil.isEmpty(Config.Agent.INSTANCE_UUID) ? UUID.randomUUID().toString().replaceAll("-", "") : Config.Agent.INSTANCE_UUID;
    }

    @Override
    public void boot() throws Throwable {
        this.applicationRegisterFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("ServiceAndEndpointRegisterClient")).scheduleAtFixedRate(new RunnableWithExceptionProtection(this, new RunnableWithExceptionProtection.CallbackWhenException(){

            @Override
            public void handle(Throwable t) {
                logger.error("unexpected exception.", t);
            }
        }), 0L, Config.Collector.APP_AND_SERVICE_REGISTER_CHECK_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        this.applicationRegisterFuture.cancel(true);
    }

    @Override
    public void run() {
        logger.debug("ServiceAndEndpointRegisterClient running, status:{}.", new Object[]{this.status});
        boolean shouldTry = true;
        while (GRPCChannelStatus.CONNECTED.equals((Object)this.status) && shouldTry) {
            shouldTry = false;
            try {
                if (RemoteDownstreamConfig.Agent.SERVICE_ID == DictionaryUtil.nullValue()) {
                    ServiceRegisterMapping serviceRegisterMapping;
                    if (this.registerBlockingStub == null || (serviceRegisterMapping = this.registerBlockingStub.doServiceRegister(Services.newBuilder().addServices(Service.newBuilder().setServiceName(Config.Agent.SERVICE_NAME)).build())) == null) continue;
                    for (KeyIntValuePair registered : serviceRegisterMapping.getServicesList()) {
                        if (!Config.Agent.SERVICE_NAME.equals(registered.getKey())) continue;
                        RemoteDownstreamConfig.Agent.SERVICE_ID = registered.getValue();
                        shouldTry = true;
                    }
                    continue;
                }
                if (this.registerBlockingStub == null) continue;
                if (RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID == DictionaryUtil.nullValue()) {
                    ServiceInstanceRegisterMapping instanceMapping = this.registerBlockingStub.doServiceInstanceRegister(ServiceInstances.newBuilder().addInstances(ServiceInstance.newBuilder().setServiceId(RemoteDownstreamConfig.Agent.SERVICE_ID).setInstanceUUID(INSTANCE_UUID).setTime(System.currentTimeMillis()).addAllProperties(OSUtil.buildOSInfo())).build());
                    for (KeyIntValuePair serviceInstance : instanceMapping.getServiceInstancesList()) {
                        int serviceInstanceId;
                        if (!INSTANCE_UUID.equals(serviceInstance.getKey()) || (serviceInstanceId = serviceInstance.getValue()) == DictionaryUtil.nullValue()) continue;
                        RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID = serviceInstanceId;
                    }
                    continue;
                }
                this.serviceInstancePingStub.doPing(ServiceInstancePingPkg.newBuilder().setServiceInstanceId(RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID).setTime(System.currentTimeMillis()).setServiceInstanceUUID(INSTANCE_UUID).build());
                NetworkAddressDictionary.INSTANCE.syncRemoteDictionary(this.registerBlockingStub);
                EndpointNameDictionary.INSTANCE.syncRemoteDictionary(this.registerBlockingStub);
            }
            catch (Throwable t) {
                logger.error(t, "ServiceAndEndpointRegisterClient execute fail.", new Object[0]);
                ServiceManager.INSTANCE.findService(GRPCChannelManager.class).reportError(t);
            }
        }
    }
}

