/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;

public class GRPCStreamServiceStatus {
    private static final ILog logger = LogManager.getLogger(GRPCStreamServiceStatus.class);
    private volatile boolean status;

    public GRPCStreamServiceStatus(boolean status) {
        this.status = status;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void finished() {
        this.status = true;
    }

    public boolean wait4Finish(long maxTimeout) {
        for (long time = 0L; !this.status && time <= maxTimeout; time += 5L) {
            this.try2Sleep(5L);
        }
        return this.status;
    }

    public void wait4Finish() {
        long recheckCycle = 5L;
        long hasWaited = 0L;
        long maxCycle = 30000L;
        while (!this.status) {
            this.try2Sleep(recheckCycle);
            hasWaited += recheckCycle;
            if (recheckCycle >= maxCycle) {
                logger.warn("Collector traceSegment service doesn't response in {} seconds.", hasWaited);
                continue;
            }
            recheckCycle = recheckCycle * 2L > maxCycle ? maxCycle : recheckCycle * 2L;
        }
    }

    private void try2Sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

