/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.AuthenticationDecorator;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannel;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.agent.core.remote.StandardChannelBuilder;
import org.apache.skywalking.apm.agent.core.remote.TLSChannelBuilder;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.StatusRuntimeException;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class GRPCChannelManager
implements BootService,
Runnable {
    private static final ILog logger = LogManager.getLogger(GRPCChannelManager.class);
    private volatile GRPCChannel managedChannel = null;
    private volatile ScheduledFuture<?> connectCheckFuture;
    private volatile boolean reconnect = true;
    private Random random = new Random();
    private List<GRPCChannelListener> listeners = Collections.synchronizedList(new LinkedList());
    private volatile List<String> grpcServers;
    private volatile int selectedIdx = -1;

    @Override
    public void prepare() throws Throwable {
    }

    @Override
    public void boot() throws Throwable {
        if (Config.Collector.BACKEND_SERVICE.trim().length() == 0) {
            logger.error("Collector server addresses are not set.");
            logger.error("Agent will not uplink any data.");
            return;
        }
        this.grpcServers = Arrays.asList(Config.Collector.BACKEND_SERVICE.split(","));
        this.connectCheckFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("GRPCChannelManager")).scheduleAtFixedRate(new RunnableWithExceptionProtection(this, new RunnableWithExceptionProtection.CallbackWhenException(){

            @Override
            public void handle(Throwable t) {
                logger.error("unexpected exception.", t);
            }
        }), 0L, Config.Collector.GRPC_CHANNEL_CHECK_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        if (this.connectCheckFuture != null) {
            this.connectCheckFuture.cancel(true);
        }
        if (this.managedChannel != null) {
            this.managedChannel.shutdownNow();
        }
        logger.debug("Selected collector grpc service shutdown.");
    }

    @Override
    public void run() {
        logger.debug("Selected collector grpc service running, reconnect:{}.", this.reconnect);
        if (this.reconnect) {
            if (this.grpcServers.size() > 0) {
                String server = "";
                try {
                    int index = Math.abs(this.random.nextInt()) % this.grpcServers.size();
                    if (index != this.selectedIdx) {
                        this.selectedIdx = index;
                        server = this.grpcServers.get(index);
                        String[] ipAndPort = server.split(":");
                        if (this.managedChannel != null) {
                            this.managedChannel.shutdownNow();
                        }
                        this.managedChannel = GRPCChannel.newBuilder(ipAndPort[0], Integer.parseInt(ipAndPort[1])).addManagedChannelBuilder(new StandardChannelBuilder()).addManagedChannelBuilder(new TLSChannelBuilder()).addChannelDecorator(new AuthenticationDecorator()).build();
                        this.notify(GRPCChannelStatus.CONNECTED);
                    }
                    this.reconnect = false;
                    return;
                }
                catch (Throwable t) {
                    logger.error(t, "Create channel to {} fail.", server);
                }
            }
            logger.debug("Selected collector grpc service is not available. Wait {} seconds to retry", Config.Collector.GRPC_CHANNEL_CHECK_INTERVAL);
        }
    }

    public void addChannelListener(GRPCChannelListener listener) {
        this.listeners.add(listener);
    }

    public Channel getChannel() {
        return this.managedChannel.getChannel();
    }

    public void reportError(Throwable throwable) {
        if (this.isNetworkError(throwable)) {
            this.reconnect = true;
        }
    }

    private void notify(GRPCChannelStatus status) {
        for (GRPCChannelListener listener : this.listeners) {
            try {
                listener.statusChanged(status);
            }
            catch (Throwable t) {
                logger.error(t, "Fail to notify {} about channel connected.", listener.getClass().getName());
            }
        }
    }

    private boolean isNetworkError(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            return this.statusEquals(statusRuntimeException.getStatus(), Status.UNAVAILABLE, Status.PERMISSION_DENIED, Status.UNAUTHENTICATED, Status.RESOURCE_EXHAUSTED, Status.UNKNOWN);
        }
        return false;
    }

    private boolean statusEquals(Status sourceStatus, Status ... potentialStatus) {
        for (Status status : potentialStatus) {
            if (sourceStatus.getCode() != status.getCode()) continue;
            return true;
        }
        return false;
    }
}

