/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import java.util.Arrays;
import java.util.List;
import org.apache.skywalking.apm.agent.core.plugin.match.ClassMatch;
import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;

public class MultiClassNameMatch
implements IndirectMatch {
    private List<String> matchClassNames;

    private MultiClassNameMatch(String[] classNames) {
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException("match class names is null");
        }
        this.matchClassNames = Arrays.asList(classNames);
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = null;
        for (String name : this.matchClassNames) {
            if (junction == null) {
                junction = ElementMatchers.named(name);
                continue;
            }
            junction = junction.or(ElementMatchers.named(name));
        }
        return junction;
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        return this.matchClassNames.contains(typeDescription.getTypeName());
    }

    public static ClassMatch byMultiClassMatch(String ... classNames) {
        return new MultiClassNameMatch(classNames);
    }
}

