/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginBootstrap;

public class AgentClassLoader
extends ClassLoader {
    private static final ILog logger;
    private static AgentClassLoader DEFAULT_LOADER;
    private List<File> classpath;
    private List<Jar> allJars;
    private ReentrantLock jarScanLock = new ReentrantLock();

    private static void tryRegisterAsParallelCapable() {
        Method[] methods = ClassLoader.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!"registerAsParallelCapable".equalsIgnoreCase(methodName)) continue;
            try {
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                logger.warn(e, "can not invoke ClassLoader.registerAsParallelCapable()", new Object[0]);
            }
            return;
        }
    }

    public static AgentClassLoader getDefault() {
        return DEFAULT_LOADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initDefaultLoader() throws AgentPackageNotFoundException {
        if (DEFAULT_LOADER != null) return;
        Class<AgentClassLoader> clazz = AgentClassLoader.class;
        synchronized (AgentClassLoader.class) {
            if (DEFAULT_LOADER != null) return;
            DEFAULT_LOADER = new AgentClassLoader(PluginBootstrap.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public AgentClassLoader(ClassLoader parent) throws AgentPackageNotFoundException {
        super(parent);
        File agentDictionary = AgentPackagePath.getPath();
        this.classpath = new LinkedList<File>();
        this.classpath.add(new File(agentDictionary, "plugins"));
        this.classpath.add(new File(agentDictionary, "activations"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        List<Jar> allJars = this.getAllJars();
        String path = name.replace('.', '/').concat(".class");
        for (Jar jar : allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(path);
            if (entry == null) continue;
            try {
                URL classFileUrl = new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + path);
                byte[] data = null;
                BufferedInputStream is = null;
                ByteArrayOutputStream baos = null;
                try {
                    is = new BufferedInputStream(classFileUrl.openStream());
                    baos = new ByteArrayOutputStream();
                    int ch = 0;
                    while ((ch = is.read()) != -1) {
                        baos.write(ch);
                    }
                    data = baos.toByteArray();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return this.defineClass(name, data, 0, data.length);
            }
            catch (MalformedURLException e) {
                logger.error(e, "find class fail.", new Object[0]);
            }
            catch (IOException e) {
                logger.error(e, "find class fail.", new Object[0]);
            }
        }
        throw new ClassNotFoundException("Can't find " + name);
    }

    @Override
    protected URL findResource(String name) {
        List<Jar> allJars = this.getAllJars();
        for (Jar jar : allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(name);
            if (entry == null) continue;
            try {
                return new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + name);
            }
            catch (MalformedURLException e) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        LinkedList<URL> allResources = new LinkedList<URL>();
        List<Jar> allJars = this.getAllJars();
        for (Jar jar : allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(name);
            if (entry == null) continue;
            allResources.add(new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + name));
        }
        final Iterator iterator = allResources.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)iterator.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Jar> getAllJars() {
        if (this.allJars == null) {
            this.jarScanLock.lock();
            try {
                if (this.allJars == null) {
                    this.allJars = new LinkedList<Jar>();
                    for (File path : this.classpath) {
                        String[] jarFileNames;
                        if (!path.exists() || !path.isDirectory()) continue;
                        for (String fileName : jarFileNames = path.list(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith(".jar");
                            }
                        })) {
                            try {
                                File file = new File(path, fileName);
                                Jar jar = new Jar(new JarFile(file), file);
                                this.allJars.add(jar);
                                logger.info("{} loaded.", file.toString());
                            }
                            catch (IOException e) {
                                logger.error(e, "{} jar file can't be resolved", fileName);
                            }
                        }
                    }
                }
            }
            finally {
                this.jarScanLock.unlock();
            }
        }
        return this.allJars;
    }

    static {
        AgentClassLoader.tryRegisterAsParallelCapable();
        logger = LogManager.getLogger(AgentClassLoader.class);
    }

    private class Jar {
        private JarFile jarFile;
        private File sourceFile;

        private Jar(JarFile jarFile, File sourceFile) {
            this.jarFile = jarFile;
            this.sourceFile = sourceFile;
        }
    }
}

