/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.loader.InterceptorInstanceLoader;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.This;

public class InstMethodsInter {
    private static final ILog logger = LogManager.getLogger(InstMethodsInter.class);
    private InstanceMethodsAroundInterceptor interceptor;

    public InstMethodsInter(String instanceMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            this.interceptor = (InstanceMethodsAroundInterceptor)InterceptorInstanceLoader.load(instanceMethodsAroundInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceMethodsAroundInterceptor.", t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@This Object obj, @AllArguments Object[] allArguments, @SuperCall Callable<?> zuper, @Origin Method method) throws Throwable {
        EnhancedInstance targetObject = (EnhancedInstance)obj;
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            this.interceptor.beforeMethod(targetObject, method, allArguments, method.getParameterTypes(), result);
        }
        catch (Throwable t) {
            logger.error(t, "class[{}] before method[{}] intercept failure", obj.getClass(), method.getName());
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                try {
                    this.interceptor.handleMethodException(targetObject, method, allArguments, method.getParameterTypes(), t);
                    throw t;
                }
                catch (Throwable t2) {
                    logger.error(t2, "class[{}] handle method[{}] exception failure", obj.getClass(), method.getName());
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    ret = this.interceptor.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret);
                    throw throwable;
                }
                catch (Throwable t2) {
                    logger.error(t2, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
                }
                throw throwable;
            }
        }
        try {
            return this.interceptor.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret);
        }
        catch (Throwable t) {
            logger.error(t, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
            return ret;
        }
    }
}

