/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.exception.IllegalPluginDefineException;

public enum PluginCfg {
    INSTANCE;

    private static final ILog logger;
    private List<PluginDefine> pluginClassList = new ArrayList<PluginDefine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(InputStream input) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String pluginDefine = null;
            while ((pluginDefine = reader.readLine()) != null) {
                try {
                    if (pluginDefine == null || pluginDefine.trim().length() == 0 || pluginDefine.startsWith("#")) continue;
                    PluginDefine plugin = PluginDefine.build(pluginDefine);
                    this.pluginClassList.add(plugin);
                }
                catch (IllegalPluginDefineException e) {
                    logger.error(e, "Failed to format plugin({}) define.", pluginDefine);
                }
            }
        }
        finally {
            input.close();
        }
    }

    public List<PluginDefine> getPluginClassList() {
        return this.pluginClassList;
    }

    static {
        logger = LogManager.getLogger(PluginCfg.class);
    }
}

