/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.os;

import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.network.common.KeyStringValuePair;

public class OSUtil {
    private static volatile String OS_NAME;
    private static volatile String HOST_NAME;
    private static volatile List<String> IPV4_LIST;
    private static volatile int PROCESS_NO;

    public static String getOsName() {
        if (OS_NAME == null) {
            OS_NAME = System.getProperty("os.name");
        }
        return OS_NAME;
    }

    public static String getHostName() {
        if (HOST_NAME == null) {
            try {
                InetAddress host = InetAddress.getLocalHost();
                HOST_NAME = host.getHostName();
            }
            catch (UnknownHostException e) {
                HOST_NAME = "unknown";
            }
        }
        return HOST_NAME;
    }

    public static List<String> getAllIPV4() {
        if (IPV4_LIST == null) {
            IPV4_LIST = new LinkedList<String>();
            try {
                Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
                while (interfs.hasMoreElements()) {
                    NetworkInterface networkInterface = interfs.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        String addressStr;
                        InetAddress address = inetAddresses.nextElement();
                        if (!(address instanceof Inet4Address) || "127.0.0.1".equals(addressStr = address.getHostAddress())) continue;
                        IPV4_LIST.add(addressStr);
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return IPV4_LIST;
    }

    public static int getProcessNo() {
        if (PROCESS_NO == 0) {
            try {
                PROCESS_NO = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
            }
            catch (Exception e) {
                PROCESS_NO = -1;
            }
        }
        return PROCESS_NO;
    }

    public static List<KeyStringValuePair> buildOSInfo() {
        List<String> allIPV4;
        String hostName;
        ArrayList<KeyStringValuePair> osInfo = new ArrayList<KeyStringValuePair>();
        String osName = OSUtil.getOsName();
        if (osName != null) {
            osInfo.add(KeyStringValuePair.newBuilder().setKey("os_name").setValue(osName).build());
        }
        if ((hostName = OSUtil.getHostName()) != null) {
            osInfo.add(KeyStringValuePair.newBuilder().setKey("host_name").setValue(hostName).build());
        }
        if ((allIPV4 = OSUtil.getAllIPV4()).size() > 0) {
            for (String ipv4 : allIPV4) {
                osInfo.add(KeyStringValuePair.newBuilder().setKey("ipv4").setValue(ipv4).build());
            }
        }
        osInfo.add(KeyStringValuePair.newBuilder().setKey("process_no").setValue(OSUtil.getProcessNo() + "").build());
        osInfo.add(KeyStringValuePair.newBuilder().setKey("language").setValue("java").build());
        return osInfo;
    }

    static {
        PROCESS_NO = 0;
    }
}

