/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.logging.core.IWriter;
import org.apache.skywalking.apm.agent.core.logging.core.LogMessageHolder;
import org.apache.skywalking.apm.dependencies.com.lmax.disruptor.EventFactory;
import org.apache.skywalking.apm.dependencies.com.lmax.disruptor.EventHandler;
import org.apache.skywalking.apm.dependencies.com.lmax.disruptor.RingBuffer;
import org.apache.skywalking.apm.dependencies.com.lmax.disruptor.dsl.Disruptor;
import org.apache.skywalking.apm.dependencies.com.lmax.disruptor.util.DaemonThreadFactory;

public class FileWriter
implements IWriter,
EventHandler<LogMessageHolder> {
    private static FileWriter INSTANCE;
    private static final Object CREATE_LOCK;
    private Disruptor<LogMessageHolder> disruptor = new Disruptor<LogMessageHolder>(new EventFactory<LogMessageHolder>(){

        @Override
        public LogMessageHolder newInstance() {
            return new LogMessageHolder();
        }
    }, 1024, DaemonThreadFactory.INSTANCE);
    private RingBuffer<LogMessageHolder> buffer;
    private FileOutputStream fileOutputStream;
    private volatile boolean started = false;
    private volatile int fileSize;
    private volatile int lineNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileWriter get() {
        if (INSTANCE == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new FileWriter();
                }
            }
        }
        return INSTANCE;
    }

    private FileWriter() {
        this.disruptor.handleEventsWith(this);
        this.buffer = this.disruptor.getRingBuffer();
        this.lineNum = 0;
        this.disruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(LogMessageHolder event, long sequence, boolean endOfBatch) throws Exception {
        if (this.hasWriteStream()) {
            try {
                ++this.lineNum;
                this.write(event.getMessage() + Constants.LINE_SEPARATOR, endOfBatch);
            }
            finally {
                event.setMessage(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String message, boolean forceFlush) {
        try {
            this.fileOutputStream.write(message.getBytes());
            this.fileSize += message.length();
            if (forceFlush || this.lineNum % 20 == 0) {
                this.fileOutputStream.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.switchFile();
        }
    }

    private void switchFile() {
        if (this.fileSize > Config.Logging.MAX_FILE_SIZE) {
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    FileWriter.this.fileOutputStream.flush();
                    return null;
                }
            });
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    FileWriter.this.fileOutputStream.close();
                    return null;
                }
            });
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    new File(Config.Logging.DIR, Config.Logging.FILE_NAME).renameTo(new File(Config.Logging.DIR, Config.Logging.FILE_NAME + new SimpleDateFormat(".yyyy_MM_dd_HH_mm_ss").format(new Date())));
                    return null;
                }
            });
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    FileWriter.this.fileOutputStream = null;
                    FileWriter.this.started = false;
                    return null;
                }
            });
        }
    }

    private void forceExecute(Callable callable) {
        try {
            callable.call();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasWriteStream() {
        if (this.fileOutputStream != null) {
            return true;
        }
        if (!this.started) {
            File logFilePath = new File(Config.Logging.DIR);
            if (!logFilePath.exists()) {
                logFilePath.mkdirs();
            } else if (!logFilePath.isDirectory()) {
                System.err.println("Log dir(" + Config.Logging.DIR + ") is not a directory.");
            }
            try {
                this.fileOutputStream = new FileOutputStream(new File(logFilePath, Config.Logging.FILE_NAME), true);
                this.fileSize = Long.valueOf(new File(logFilePath, Config.Logging.FILE_NAME).length()).intValue();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.started = true;
        }
        return this.fileOutputStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String message) {
        long next = this.buffer.next();
        try {
            LogMessageHolder messageHolder = this.buffer.get(next);
            messageHolder.setMessage(message);
        }
        finally {
            this.buffer.publish(next);
        }
    }

    static {
        CREATE_LOCK = new Object();
    }
}

