/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.core.LogLevel;
import org.apache.skywalking.apm.agent.core.logging.core.WriterFactory;
import org.apache.skywalking.apm.util.StringUtil;

public class EasyLogger
implements ILog {
    private Class targetClass;

    public EasyLogger(Class targetClass) {
        this.targetClass = targetClass;
    }

    protected void logger(LogLevel level, String message, Throwable e) {
        WriterFactory.getLogWriter().write(this.format(level, message, e));
    }

    private String replaceParam(String message, Object ... parameters) {
        int index;
        int startSize = 0;
        int parametersIndex = 0;
        String tmpMessage = message;
        while ((index = message.indexOf("{}", startSize)) != -1 && parametersIndex < parameters.length) {
            tmpMessage = tmpMessage.replaceFirst("\\{\\}", Matcher.quoteReplacement(String.valueOf(parameters[parametersIndex++])));
            startSize = index + 2;
        }
        return tmpMessage;
    }

    String format(LogLevel level, String message, Throwable t) {
        return StringUtil.join(' ', level.name(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date()), Thread.currentThread().getName(), this.targetClass.getSimpleName(), ": ", message, t == null ? "" : this.format(t));
    }

    String format(Throwable t) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        t.printStackTrace(new PrintWriter(buf, true));
        String expMessage = buf.toString();
        try {
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Constants.LINE_SEPARATOR + expMessage;
    }

    @Override
    public void info(String format) {
        if (this.isInfoEnable()) {
            this.logger(LogLevel.INFO, format, null);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnable()) {
            this.logger(LogLevel.INFO, this.replaceParam(format, arguments), null);
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnable()) {
            this.logger(LogLevel.WARN, this.replaceParam(format, arguments), null);
        }
    }

    @Override
    public void warn(Throwable e, String format, Object ... arguments) {
        if (this.isWarnEnable()) {
            this.logger(LogLevel.WARN, this.replaceParam(format, arguments), e);
        }
    }

    @Override
    public void error(String format, Throwable e) {
        if (this.isErrorEnable()) {
            this.logger(LogLevel.ERROR, format, e);
        }
    }

    @Override
    public void error(Throwable e, String format, Object ... arguments) {
        if (this.isErrorEnable()) {
            this.logger(LogLevel.ERROR, this.replaceParam(format, arguments), e);
        }
    }

    @Override
    public boolean isDebugEnable() {
        return LogLevel.DEBUG.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isInfoEnable() {
        return LogLevel.INFO.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isWarnEnable() {
        return LogLevel.WARN.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public boolean isErrorEnable() {
        return LogLevel.ERROR.compareTo(Config.Logging.LEVEL) >= 0;
    }

    @Override
    public void debug(String format) {
        if (this.isDebugEnable()) {
            this.logger(LogLevel.DEBUG, format, null);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnable()) {
            this.logger(LogLevel.DEBUG, this.replaceParam(format, arguments), null);
        }
    }

    @Override
    public void error(String format) {
        if (this.isErrorEnable()) {
            this.logger(LogLevel.ERROR, format, null);
        }
    }
}

