/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.memorypool;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.CMSCollectorModule;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.G1CollectorModule;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.MemoryPoolMetricsAccessor;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.ParallelCollectorModule;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.SerialCollectorModule;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.UnknownMemoryPool;
import org.apache.skywalking.apm.network.language.agent.MemoryPool;

public enum MemoryPoolProvider {
    INSTANCE;

    private MemoryPoolMetricsAccessor metricAccessor;
    private List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();

    private MemoryPoolProvider() {
        for (MemoryPoolMXBean bean : this.beans) {
            String name = bean.getName();
            MemoryPoolMetricsAccessor accessor = this.findByBeanName(name);
            if (accessor == null) continue;
            this.metricAccessor = accessor;
            break;
        }
        if (this.metricAccessor == null) {
            this.metricAccessor = new UnknownMemoryPool();
        }
    }

    public List<MemoryPool> getMemoryPoolMetricsList() {
        return this.metricAccessor.getMemoryPoolMetricsList();
    }

    private MemoryPoolMetricsAccessor findByBeanName(String name) {
        if (name.indexOf("PS") > -1) {
            return new ParallelCollectorModule(this.beans);
        }
        if (name.indexOf("CMS") > -1) {
            return new CMSCollectorModule(this.beans);
        }
        if (name.indexOf("G1") > -1) {
            return new G1CollectorModule(this.beans);
        }
        if (name.equals("Survivor Space")) {
            return new SerialCollectorModule(this.beans);
        }
        return null;
    }
}

