/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.memorypool;

import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.MemoryPoolMetricsAccessor;
import org.apache.skywalking.apm.network.language.agent.MemoryPool;
import org.apache.skywalking.apm.network.language.agent.PoolType;

public abstract class MemoryPoolModule
implements MemoryPoolMetricsAccessor {
    private List<MemoryPoolMXBean> beans;

    public MemoryPoolModule(List<MemoryPoolMXBean> beans) {
        this.beans = beans;
    }

    @Override
    public List<MemoryPool> getMemoryPoolMetricsList() {
        LinkedList<MemoryPool> poolList = new LinkedList<MemoryPool>();
        for (MemoryPoolMXBean bean : this.beans) {
            PoolType type;
            String name = bean.getName();
            if (this.contains(this.getCodeCacheNames(), name)) {
                type = PoolType.CODE_CACHE_USAGE;
            } else if (this.contains(this.getEdenNames(), name)) {
                type = PoolType.NEWGEN_USAGE;
            } else if (this.contains(this.getOldNames(), name)) {
                type = PoolType.OLDGEN_USAGE;
            } else if (this.contains(this.getSurvivorNames(), name)) {
                type = PoolType.SURVIVOR_USAGE;
            } else if (this.contains(this.getMetaspaceNames(), name)) {
                type = PoolType.METASPACE_USAGE;
            } else {
                if (!this.contains(this.getPermNames(), name)) continue;
                type = PoolType.PERMGEN_USAGE;
            }
            MemoryUsage usage = bean.getUsage();
            poolList.add(MemoryPool.newBuilder().setType(type).setInit(usage.getInit()).setMax(usage.getMax()).setCommited(usage.getCommitted()).setUsed(usage.getUsed()).build());
        }
        return poolList;
    }

    private boolean contains(String[] possibleNames, String name) {
        for (String possibleName : possibleNames) {
            if (!name.equals(possibleName)) continue;
            return true;
        }
        return false;
    }

    protected abstract String[] getPermNames();

    protected abstract String[] getCodeCacheNames();

    protected abstract String[] getEdenNames();

    protected abstract String[] getOldNames();

    protected abstract String[] getSurvivorNames();

    protected abstract String[] getMetaspaceNames();
}

