/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.gc.GCMetricAccessor;
import org.apache.skywalking.apm.network.language.agent.GC;
import org.apache.skywalking.apm.network.language.agent.GCPhrase;

public abstract class GCModule
implements GCMetricAccessor {
    private List<GarbageCollectorMXBean> beans;
    private long lastOGCCount = 0L;
    private long lastYGCCount = 0L;
    private long lastOGCCollectionTime = 0L;
    private long lastYGCCollectionTime = 0L;

    public GCModule(List<GarbageCollectorMXBean> beans) {
        this.beans = beans;
    }

    @Override
    public List<GC> getGCList() {
        LinkedList<GC> gcList = new LinkedList<GC>();
        for (GarbageCollectorMXBean bean : this.beans) {
            long time;
            long collectionCount;
            GCPhrase phrase;
            String name = bean.getName();
            long gcCount = 0L;
            long gcTime = 0L;
            if (name.equals(this.getNewGCName())) {
                phrase = GCPhrase.NEW;
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastYGCCount;
                this.lastYGCCount = collectionCount;
                time = bean.getCollectionTime();
                gcTime = time - this.lastYGCCollectionTime;
                this.lastYGCCollectionTime = time;
            } else {
                if (!name.equals(this.getOldGCName())) continue;
                phrase = GCPhrase.OLD;
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastOGCCount;
                this.lastOGCCount = collectionCount;
                time = bean.getCollectionTime();
                gcTime = time - this.lastOGCCollectionTime;
                this.lastOGCCollectionTime = time;
            }
            gcList.add(GC.newBuilder().setPhrase(phrase).setCount(gcCount).setTime(gcTime).build());
        }
        return gcList;
    }

    protected abstract String getOldGCName();

    protected abstract String getNewGCName();
}

