/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.cpu;

import org.apache.skywalking.apm.agent.core.jvm.cpu.CPUMetricsAccessor;
import org.apache.skywalking.apm.agent.core.jvm.cpu.NoSupportedCPUAccessor;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.os.ProcessorUtil;
import org.apache.skywalking.apm.network.common.CPU;

public enum CPUProvider {
    INSTANCE;

    private CPUMetricsAccessor cpuMetricsAccessor;

    private CPUProvider() {
        int processorNum = ProcessorUtil.getNumberOfProcessors();
        try {
            this.cpuMetricsAccessor = (CPUMetricsAccessor)CPUProvider.class.getClassLoader().loadClass("org.apache.skywalking.apm.agent.core.jvm.cpu.SunCpuAccessor").getConstructor(Integer.TYPE).newInstance(processorNum);
        }
        catch (Exception e) {
            this.cpuMetricsAccessor = new NoSupportedCPUAccessor(processorNum);
            ILog logger = LogManager.getLogger(CPUProvider.class);
            logger.error(e, "Only support accessing CPU metrics in SUN JVM platform.", new Object[0]);
        }
    }

    public CPU getCpuMetric() {
        return this.cpuMetricsAccessor.getCPUMetrics();
    }
}

