/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm;

import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.RemoteDownstreamConfig;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.agent.core.jvm.cpu.CPUProvider;
import org.apache.skywalking.apm.agent.core.jvm.gc.GCProvider;
import org.apache.skywalking.apm.agent.core.jvm.memory.MemoryProvider;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.MemoryPoolProvider;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.network.language.agent.JVMMetric;
import org.apache.skywalking.apm.network.language.agent.v2.JVMMetricCollection;
import org.apache.skywalking.apm.network.language.agent.v2.JVMMetricReportServiceGrpc;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class JVMService
implements BootService,
Runnable {
    private static final ILog logger = LogManager.getLogger(JVMService.class);
    private LinkedBlockingQueue<JVMMetric> queue;
    private volatile ScheduledFuture<?> collectMetricFuture;
    private volatile ScheduledFuture<?> sendMetricFuture;
    private Sender sender;

    @Override
    public void prepare() throws Throwable {
        this.queue = new LinkedBlockingQueue(Config.Jvm.BUFFER_SIZE);
        this.sender = new Sender();
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this.sender);
    }

    @Override
    public void boot() throws Throwable {
        this.collectMetricFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("JVMService-produce")).scheduleAtFixedRate(new RunnableWithExceptionProtection(this, new RunnableWithExceptionProtection.CallbackWhenException(){

            @Override
            public void handle(Throwable t) {
                logger.error("JVMService produces metrics failure.", t);
            }
        }), 0L, 1L, TimeUnit.SECONDS);
        this.sendMetricFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("JVMService-consume")).scheduleAtFixedRate(new RunnableWithExceptionProtection(this.sender, new RunnableWithExceptionProtection.CallbackWhenException(){

            @Override
            public void handle(Throwable t) {
                logger.error("JVMService consumes and upload failure.", t);
            }
        }), 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        this.collectMetricFuture.cancel(true);
        this.sendMetricFuture.cancel(true);
    }

    @Override
    public void run() {
        if (RemoteDownstreamConfig.Agent.SERVICE_ID != DictionaryUtil.nullValue() && RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID != DictionaryUtil.nullValue()) {
            long currentTimeMillis = System.currentTimeMillis();
            try {
                JVMMetric.Builder jvmBuilder = JVMMetric.newBuilder();
                jvmBuilder.setTime(currentTimeMillis);
                jvmBuilder.setCpu(CPUProvider.INSTANCE.getCpuMetric());
                jvmBuilder.addAllMemory(MemoryProvider.INSTANCE.getMemoryMetricList());
                jvmBuilder.addAllMemoryPool(MemoryPoolProvider.INSTANCE.getMemoryPoolMetricsList());
                jvmBuilder.addAllGc(GCProvider.INSTANCE.getGCList());
                JVMMetric jvmMetric = jvmBuilder.build();
                if (!this.queue.offer(jvmMetric)) {
                    this.queue.poll();
                    this.queue.offer(jvmMetric);
                }
            }
            catch (Exception e) {
                logger.error(e, "Collect JVM info fail.", new Object[0]);
            }
        }
    }

    private class Sender
    implements Runnable,
    GRPCChannelListener {
        private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
        private volatile JVMMetricReportServiceGrpc.JVMMetricReportServiceBlockingStub stub = null;

        private Sender() {
        }

        @Override
        public void run() {
            if (RemoteDownstreamConfig.Agent.SERVICE_ID != DictionaryUtil.nullValue() && RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID != DictionaryUtil.nullValue() && this.status == GRPCChannelStatus.CONNECTED) {
                try {
                    JVMMetricCollection.Builder builder = JVMMetricCollection.newBuilder();
                    LinkedList buffer = new LinkedList();
                    JVMService.this.queue.drainTo(buffer);
                    if (buffer.size() > 0) {
                        builder.addAllMetrics(buffer);
                        builder.setServiceInstanceId(RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID);
                        this.stub.collect(builder.build());
                    }
                }
                catch (Throwable t) {
                    logger.error(t, "send JVM metrics to Collector fail.", new Object[0]);
                }
            }
        }

        @Override
        public void statusChanged(GRPCChannelStatus status) {
            if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
                Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
                this.stub = JVMMetricReportServiceGrpc.newBlockingStub(channel);
            }
            this.status = status;
        }
    }
}

