/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.dictionary;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.dictionary.Found;
import org.apache.skywalking.apm.agent.core.dictionary.NotFound;
import org.apache.skywalking.apm.agent.core.dictionary.PossibleFound;
import org.apache.skywalking.apm.dependencies.io.netty.util.internal.ConcurrentSet;
import org.apache.skywalking.apm.network.common.KeyIntValuePair;
import org.apache.skywalking.apm.network.register.v2.NetAddressMapping;
import org.apache.skywalking.apm.network.register.v2.NetAddresses;
import org.apache.skywalking.apm.network.register.v2.RegisterGrpc;

public enum NetworkAddressDictionary {
    INSTANCE;

    private Map<String, Integer> applicationDictionary = new ConcurrentHashMap<String, Integer>();
    private Set<String> unRegisterServices = new ConcurrentSet<String>();

    public PossibleFound find(String networkAddress) {
        Integer applicationId = this.applicationDictionary.get(networkAddress);
        if (applicationId != null) {
            return new Found(applicationId);
        }
        if (this.applicationDictionary.size() + this.unRegisterServices.size() < Config.Dictionary.SERVICE_CODE_BUFFER_SIZE) {
            this.unRegisterServices.add(networkAddress);
        }
        return new NotFound();
    }

    public void syncRemoteDictionary(RegisterGrpc.RegisterBlockingStub networkAddressRegisterServiceBlockingStub) {
        NetAddressMapping networkAddressMappings;
        if (this.unRegisterServices.size() > 0 && (networkAddressMappings = networkAddressRegisterServiceBlockingStub.doNetworkAddressRegister(NetAddresses.newBuilder().addAllAddresses(this.unRegisterServices).build())).getAddressIdsCount() > 0) {
            for (KeyIntValuePair keyWithIntegerValue : networkAddressMappings.getAddressIdsList()) {
                this.unRegisterServices.remove(keyWithIntegerValue.getKey());
                this.applicationDictionary.put(keyWithIntegerValue.getKey(), keyWithIntegerValue.getValue());
            }
        }
    }
}

