/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.dictionary;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.dictionary.Found;
import org.apache.skywalking.apm.agent.core.dictionary.NotFound;
import org.apache.skywalking.apm.agent.core.dictionary.PossibleFound;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.dependencies.io.netty.util.internal.ConcurrentSet;
import org.apache.skywalking.apm.network.common.DetectPoint;
import org.apache.skywalking.apm.network.register.v2.Endpoint;
import org.apache.skywalking.apm.network.register.v2.EndpointMapping;
import org.apache.skywalking.apm.network.register.v2.EndpointMappingElement;
import org.apache.skywalking.apm.network.register.v2.Enpoints;
import org.apache.skywalking.apm.network.register.v2.RegisterGrpc;

public enum EndpointNameDictionary {
    INSTANCE;

    private static final ILog logger;
    private Map<OperationNameKey, Integer> endpointDictionary = new ConcurrentHashMap<OperationNameKey, Integer>();
    private Set<OperationNameKey> unRegisterEndpoints = new ConcurrentSet<OperationNameKey>();

    public PossibleFound findOrPrepare4Register(int serviceId, String endpointName, boolean isEntry, boolean isExit) {
        return this.find0(serviceId, endpointName, isEntry, isExit, true);
    }

    public PossibleFound findOnly(int serviceId, String endpointName) {
        return this.find0(serviceId, endpointName, false, false, false);
    }

    private PossibleFound find0(int serviceId, String endpointName, boolean isEntry, boolean isExit, boolean registerWhenNotFound) {
        if (endpointName == null || endpointName.length() == 0) {
            return new NotFound();
        }
        OperationNameKey key = new OperationNameKey(serviceId, endpointName, isEntry, isExit);
        Integer operationId = this.endpointDictionary.get(key);
        if (operationId != null) {
            return new Found(operationId);
        }
        if (registerWhenNotFound && this.endpointDictionary.size() + this.unRegisterEndpoints.size() < Config.Dictionary.ENDPOINT_NAME_BUFFER_SIZE) {
            this.unRegisterEndpoints.add(key);
        }
        return new NotFound();
    }

    public void syncRemoteDictionary(RegisterGrpc.RegisterBlockingStub serviceNameDiscoveryServiceBlockingStub) {
        if (this.unRegisterEndpoints.size() > 0) {
            Enpoints.Builder builder = Enpoints.newBuilder();
            for (OperationNameKey operationNameKey : this.unRegisterEndpoints) {
                Endpoint endpoint = Endpoint.newBuilder().setServiceId(operationNameKey.getServiceId()).setEndpointName(operationNameKey.getEndpointName()).setFrom(operationNameKey.getSpanType()).build();
                builder.addEndpoints(endpoint);
            }
            EndpointMapping serviceNameMappingCollection = serviceNameDiscoveryServiceBlockingStub.doEndpointRegister(builder.build());
            if (serviceNameMappingCollection.getElementsCount() > 0) {
                for (EndpointMappingElement element : serviceNameMappingCollection.getElementsList()) {
                    OperationNameKey key = new OperationNameKey(element.getServiceId(), element.getEndpointName(), DetectPoint.server.equals(element.getFrom()), DetectPoint.client.equals(element.getFrom()));
                    this.unRegisterEndpoints.remove(key);
                    this.endpointDictionary.put(key, element.getEndpointId());
                }
            }
        }
    }

    static {
        logger = LogManager.getLogger(EndpointNameDictionary.class);
    }

    private class OperationNameKey {
        private int serviceId;
        private String endpointName;
        private boolean isEntry;
        private boolean isExit;

        public OperationNameKey(int serviceId, String endpointName, boolean isEntry, boolean isExit) {
            this.serviceId = serviceId;
            this.endpointName = endpointName;
            this.isEntry = isEntry;
            this.isExit = isExit;
        }

        public int getServiceId() {
            return this.serviceId;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationNameKey key = (OperationNameKey)o;
            boolean isServiceEndpointMatch = false;
            if (this.serviceId == key.serviceId && this.endpointName.equals(key.endpointName)) {
                isServiceEndpointMatch = true;
            }
            return isServiceEndpointMatch && this.isEntry == key.isEntry && this.isExit == key.isExit;
        }

        public int hashCode() {
            int result = this.serviceId;
            result = 31 * result + this.endpointName.hashCode();
            return result;
        }

        boolean isEntry() {
            return this.isEntry;
        }

        boolean isExit() {
            return this.isExit;
        }

        DetectPoint getSpanType() {
            if (this.isEntry) {
                return DetectPoint.server;
            }
            if (this.isExit) {
                return DetectPoint.client;
            }
            return DetectPoint.UNRECOGNIZED;
        }

        public String toString() {
            return "OperationNameKey{serviceId=" + this.serviceId + ", endpointName='" + this.endpointName + '\'' + ", isEntry=" + this.isEntry + ", isExit=" + this.isExit + '}';
        }
    }
}

