/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import org.apache.skywalking.apm.agent.core.conf.RemoteDownstreamConfig;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.ids.ID;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.network.language.agent.RefType;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentReference;
import org.apache.skywalking.apm.util.StringUtil;

public class TraceSegmentRef {
    private SegmentRefType type;
    private ID traceSegmentId;
    private int spanId = -1;
    private int peerId = DictionaryUtil.nullValue();
    private String peerHost;
    private int entryServiceInstanceId = DictionaryUtil.nullValue();
    private int parentServiceInstanceId = DictionaryUtil.nullValue();
    private String entryEndpointName;
    private int entryEndpointId = DictionaryUtil.nullValue();
    private String parentEndpointName;
    private int parentEndpointId = DictionaryUtil.nullValue();

    public TraceSegmentRef(ContextCarrier carrier) {
        String parentOperationName;
        this.type = SegmentRefType.CROSS_PROCESS;
        this.traceSegmentId = carrier.getTraceSegmentId();
        this.spanId = carrier.getSpanId();
        this.parentServiceInstanceId = carrier.getParentServiceInstanceId();
        this.entryServiceInstanceId = carrier.getEntryServiceInstanceId();
        String host = carrier.getPeerHost();
        if (host.charAt(0) == '#') {
            this.peerHost = host.substring(1);
        } else {
            this.peerId = Integer.parseInt(host);
        }
        String entryOperationName = carrier.getEntryEndpointName();
        if (!StringUtil.isEmpty(entryOperationName)) {
            if (entryOperationName.charAt(0) == '#') {
                this.entryEndpointName = entryOperationName.substring(1);
            } else {
                this.entryEndpointId = Integer.parseInt(entryOperationName);
            }
        }
        if (!StringUtil.isEmpty(parentOperationName = carrier.getParentEndpointName())) {
            if (parentOperationName.charAt(0) == '#') {
                this.parentEndpointName = parentOperationName.substring(1);
            } else {
                this.parentEndpointId = Integer.parseInt(parentOperationName);
            }
        }
    }

    public TraceSegmentRef(ContextSnapshot snapshot) {
        String parentOperationName;
        this.type = SegmentRefType.CROSS_THREAD;
        this.traceSegmentId = snapshot.getTraceSegmentId();
        this.spanId = snapshot.getSpanId();
        this.parentServiceInstanceId = RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID;
        this.entryServiceInstanceId = snapshot.getEntryApplicationInstanceId();
        String entryOperationName = snapshot.getEntryOperationName();
        if (!StringUtil.isEmpty(entryOperationName)) {
            if (entryOperationName.charAt(0) == '#') {
                this.entryEndpointName = entryOperationName.substring(1);
            } else {
                this.entryEndpointId = Integer.parseInt(entryOperationName);
            }
        }
        if (!StringUtil.isEmpty(parentOperationName = snapshot.getParentOperationName())) {
            if (parentOperationName.charAt(0) == '#') {
                this.parentEndpointName = parentOperationName.substring(1);
            } else {
                this.parentEndpointId = Integer.parseInt(parentOperationName);
            }
        }
    }

    public String getEntryEndpointName() {
        return this.entryEndpointName;
    }

    public int getEntryEndpointId() {
        return this.entryEndpointId;
    }

    public int getEntryServiceInstanceId() {
        return this.entryServiceInstanceId;
    }

    public SegmentReference transform() {
        SegmentReference.Builder refBuilder = SegmentReference.newBuilder();
        if (SegmentRefType.CROSS_PROCESS.equals((Object)this.type)) {
            refBuilder.setRefType(RefType.CrossProcess);
            if (this.peerId == DictionaryUtil.nullValue()) {
                refBuilder.setNetworkAddress(this.peerHost);
            } else {
                refBuilder.setNetworkAddressId(this.peerId);
            }
        } else {
            refBuilder.setRefType(RefType.CrossThread);
        }
        refBuilder.setParentServiceInstanceId(this.parentServiceInstanceId);
        refBuilder.setEntryServiceInstanceId(this.entryServiceInstanceId);
        refBuilder.setParentTraceSegmentId(this.traceSegmentId.transform());
        refBuilder.setParentSpanId(this.spanId);
        if (this.entryEndpointId == DictionaryUtil.nullValue()) {
            if (!StringUtil.isEmpty(this.entryEndpointName)) {
                refBuilder.setEntryEndpoint(this.entryEndpointName);
            }
        } else {
            refBuilder.setEntryEndpointId(this.entryEndpointId);
        }
        if (this.parentEndpointId == DictionaryUtil.nullValue()) {
            if (!StringUtil.isEmpty(this.parentEndpointName)) {
                refBuilder.setParentEndpoint(this.parentEndpointName);
            }
        } else {
            refBuilder.setParentEndpointId(this.parentEndpointId);
        }
        return refBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceSegmentRef ref = (TraceSegmentRef)o;
        if (this.spanId != ref.spanId) {
            return false;
        }
        return this.traceSegmentId.equals(ref.traceSegmentId);
    }

    public int hashCode() {
        int result = this.traceSegmentId.hashCode();
        result = 31 * result + this.spanId;
        return result;
    }

    public static enum SegmentRefType {
        CROSS_PROCESS,
        CROSS_THREAD;

    }
}

