/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.conf.RemoteDownstreamConfig;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceIds;
import org.apache.skywalking.apm.agent.core.context.ids.GlobalIdGenerator;
import org.apache.skywalking.apm.agent.core.context.ids.ID;
import org.apache.skywalking.apm.agent.core.context.ids.NewDistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.network.language.agent.UpstreamSegment;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentObject;

public class TraceSegment {
    private ID traceSegmentId = GlobalIdGenerator.generate();
    private List<TraceSegmentRef> refs;
    private List<AbstractTracingSpan> spans = new LinkedList<AbstractTracingSpan>();
    private DistributedTraceIds relatedGlobalTraces = new DistributedTraceIds();
    private boolean ignore = false;
    private boolean isSizeLimited = false;

    public TraceSegment() {
        this.relatedGlobalTraces.append(new NewDistributedTraceId());
    }

    public void ref(TraceSegmentRef refSegment) {
        if (this.refs == null) {
            this.refs = new LinkedList<TraceSegmentRef>();
        }
        if (!this.refs.contains(refSegment)) {
            this.refs.add(refSegment);
        }
    }

    public void relatedGlobalTraces(DistributedTraceId distributedTraceId) {
        this.relatedGlobalTraces.append(distributedTraceId);
    }

    public void archive(AbstractTracingSpan finishedSpan) {
        this.spans.add(finishedSpan);
    }

    public TraceSegment finish(boolean isSizeLimited) {
        this.isSizeLimited = isSizeLimited;
        return this;
    }

    public ID getTraceSegmentId() {
        return this.traceSegmentId;
    }

    public int getServiceId() {
        return RemoteDownstreamConfig.Agent.SERVICE_ID;
    }

    public boolean hasRef() {
        return this.refs != null && this.refs.size() != 0;
    }

    public List<TraceSegmentRef> getRefs() {
        return this.refs;
    }

    public List<DistributedTraceId> getRelatedGlobalTraces() {
        return this.relatedGlobalTraces.getRelatedGlobalTraces();
    }

    public boolean isSingleSpanSegment() {
        return this.spans != null && this.spans.size() == 1;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public UpstreamSegment transform() {
        UpstreamSegment.Builder upstreamBuilder = UpstreamSegment.newBuilder();
        for (DistributedTraceId distributedTraceId : this.getRelatedGlobalTraces()) {
            upstreamBuilder = upstreamBuilder.addGlobalTraceIds(distributedTraceId.toUniqueId());
        }
        SegmentObject.Builder traceSegmentBuilder = SegmentObject.newBuilder();
        traceSegmentBuilder.setTraceSegmentId(this.traceSegmentId.transform());
        for (AbstractTracingSpan span : this.spans) {
            traceSegmentBuilder.addSpans(span.transform());
        }
        traceSegmentBuilder.setServiceId(RemoteDownstreamConfig.Agent.SERVICE_ID);
        traceSegmentBuilder.setServiceInstanceId(RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID);
        traceSegmentBuilder.setIsSizeLimited(this.isSizeLimited);
        upstreamBuilder.setSegment(traceSegmentBuilder.build().toByteString());
        return upstreamBuilder.build();
    }

    public String toString() {
        return "TraceSegment{traceSegmentId='" + this.traceSegmentId + '\'' + ", refs=" + this.refs + ", spans=" + this.spans + ", relatedGlobalTraces=" + this.relatedGlobalTraces + '}';
    }

    public int getApplicationInstanceId() {
        return RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID;
    }
}

