/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryManager;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.agent.core.dictionary.PossibleFound;
import org.apache.skywalking.apm.network.language.agent.v2.SpanObjectV2;

public abstract class StackBasedTracingSpan
extends AbstractTracingSpan {
    protected int stackDepth;
    protected String peer;
    protected int peerId;

    protected StackBasedTracingSpan(int spanId, int parentSpanId, String operationName) {
        super(spanId, parentSpanId, operationName);
        this.stackDepth = 0;
        this.peer = null;
        this.peerId = DictionaryUtil.nullValue();
    }

    protected StackBasedTracingSpan(int spanId, int parentSpanId, int operationId) {
        super(spanId, parentSpanId, operationId);
        this.stackDepth = 0;
        this.peer = null;
        this.peerId = DictionaryUtil.nullValue();
    }

    public StackBasedTracingSpan(int spanId, int parentSpanId, int operationId, int peerId) {
        super(spanId, parentSpanId, operationId);
        this.peer = null;
        this.peerId = peerId;
    }

    public StackBasedTracingSpan(int spanId, int parentSpanId, int operationId, String peer) {
        super(spanId, parentSpanId, operationId);
        this.peer = peer;
        this.peerId = DictionaryUtil.nullValue();
    }

    protected StackBasedTracingSpan(int spanId, int parentSpanId, String operationName, String peer) {
        super(spanId, parentSpanId, operationName);
        this.peer = peer;
        this.peerId = DictionaryUtil.nullValue();
    }

    protected StackBasedTracingSpan(int spanId, int parentSpanId, String operationName, int peerId) {
        super(spanId, parentSpanId, operationName);
        this.peer = null;
        this.peerId = peerId;
    }

    @Override
    public SpanObjectV2.Builder transform() {
        SpanObjectV2.Builder spanBuilder = super.transform();
        if (this.peerId != DictionaryUtil.nullValue()) {
            spanBuilder.setPeerId(this.peerId);
        } else if (this.peer != null) {
            spanBuilder.setPeer(this.peer);
        }
        return spanBuilder;
    }

    @Override
    public boolean finish(TraceSegment owner) {
        if (--this.stackDepth == 0) {
            if (this.operationId == DictionaryUtil.nullValue()) {
                this.operationId = (Integer)DictionaryManager.findEndpointSection().findOrPrepare4Register(owner.getServiceId(), this.operationName, this.isEntry(), this.isExit()).doInCondition(new PossibleFound.FoundAndObtain(){

                    @Override
                    public Object doProcess(int value) {
                        return value;
                    }
                }, new PossibleFound.NotFoundAndObtain(){

                    @Override
                    public Object doProcess() {
                        return DictionaryUtil.nullValue();
                    }
                });
            }
            return super.finish(owner);
        }
        return false;
    }

    @Override
    public AbstractSpan setPeer(final String remotePeer) {
        DictionaryManager.findNetworkAddressSection().find(remotePeer).doInCondition(new PossibleFound.Found(){

            @Override
            public void doProcess(int remotePeerId) {
                StackBasedTracingSpan.this.peerId = remotePeerId;
            }
        }, new PossibleFound.NotFound(){

            @Override
            public void doProcess() {
                StackBasedTracingSpan.this.peer = remotePeer;
            }
        });
        return this;
    }
}

