/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.util.KeyValuePair;
import org.apache.skywalking.apm.network.language.agent.v2.Log;

public class LogDataEntity {
    private long timestamp = 0L;
    private List<KeyValuePair> logs;

    private LogDataEntity(long timestamp, List<KeyValuePair> logs) {
        this.timestamp = timestamp;
        this.logs = logs;
    }

    public List<KeyValuePair> getLogs() {
        return this.logs;
    }

    public Log transform() {
        Log.Builder logMessageBuilder = Log.newBuilder();
        for (KeyValuePair log : this.logs) {
            logMessageBuilder.addData(log.transform());
        }
        logMessageBuilder.setTime(this.timestamp);
        return logMessageBuilder.build();
    }

    public static class Builder {
        protected List<KeyValuePair> logs = new LinkedList<KeyValuePair>();

        public Builder add(KeyValuePair ... fields) {
            for (KeyValuePair field : fields) {
                this.logs.add(field);
            }
            return this;
        }

        public LogDataEntity build(long timestamp) {
            return new LogDataEntity(timestamp, this.logs);
        }
    }
}

