/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.LogDataEntity;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.agent.core.context.util.KeyValuePair;
import org.apache.skywalking.apm.agent.core.context.util.TagValuePair;
import org.apache.skywalking.apm.agent.core.context.util.ThrowableTransformer;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.apm.network.language.agent.v2.SpanObjectV2;
import org.apache.skywalking.apm.network.trace.component.Component;

public abstract class AbstractTracingSpan
implements AbstractSpan {
    protected int spanId;
    protected int parentSpanId;
    protected List<TagValuePair> tags;
    protected String operationName;
    protected int operationId;
    protected SpanLayer layer;
    protected boolean isInAsyncMode = false;
    protected volatile AbstractTracerContext context;
    protected long startTime;
    protected long endTime;
    protected boolean errorOccurred = false;
    protected int componentId = 0;
    protected String componentName;
    protected List<LogDataEntity> logs;
    protected List<TraceSegmentRef> refs;

    protected AbstractTracingSpan(int spanId, int parentSpanId, String operationName) {
        this.operationName = operationName;
        this.operationId = DictionaryUtil.nullValue();
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
    }

    protected AbstractTracingSpan(int spanId, int parentSpanId, int operationId) {
        this.operationName = null;
        this.operationId = operationId;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
    }

    @Override
    @Deprecated
    public AbstractTracingSpan tag(String key, String value) {
        return this.tag(new StringTag(key), value);
    }

    @Override
    public AbstractTracingSpan tag(AbstractTag tag, String value) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagValuePair>(8);
        }
        if (tag.isCanOverwrite()) {
            for (TagValuePair pair : this.tags) {
                if (!pair.sameWith(tag)) continue;
                pair.setValue(value);
                return this;
            }
        }
        this.tags.add(new TagValuePair(tag, value));
        return this;
    }

    public boolean finish(TraceSegment owner) {
        this.endTime = System.currentTimeMillis();
        owner.archive(this);
        return true;
    }

    @Override
    public AbstractTracingSpan start() {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    @Override
    public AbstractTracingSpan log(Throwable t) {
        if (this.logs == null) {
            this.logs = new LinkedList<LogDataEntity>();
        }
        this.logs.add(new LogDataEntity.Builder().add(new KeyValuePair("event", "error")).add(new KeyValuePair("error.kind", t.getClass().getName())).add(new KeyValuePair("message", t.getMessage())).add(new KeyValuePair("stack", ThrowableTransformer.INSTANCE.convert2String(t, 4000))).build(System.currentTimeMillis()));
        return this;
    }

    @Override
    public AbstractTracingSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        if (this.logs == null) {
            this.logs = new LinkedList<LogDataEntity>();
        }
        LogDataEntity.Builder builder = new LogDataEntity.Builder();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            builder.add(new KeyValuePair(entry.getKey(), entry.getValue().toString()));
        }
        this.logs.add(builder.build(timestampMicroseconds));
        return this;
    }

    @Override
    public AbstractTracingSpan errorOccurred() {
        this.errorOccurred = true;
        return this;
    }

    @Override
    public AbstractTracingSpan setOperationName(String operationName) {
        this.operationName = operationName;
        this.operationId = DictionaryUtil.nullValue();
        return this;
    }

    @Override
    public AbstractTracingSpan setOperationId(int operationId) {
        this.operationId = operationId;
        this.operationName = null;
        return this;
    }

    @Override
    public int getSpanId() {
        return this.spanId;
    }

    @Override
    public int getOperationId() {
        return this.operationId;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public AbstractTracingSpan setLayer(SpanLayer layer) {
        this.layer = layer;
        return this;
    }

    @Override
    public AbstractTracingSpan setComponent(Component component) {
        this.componentId = component.getId();
        return this;
    }

    @Override
    public AbstractTracingSpan setComponent(String componentName) {
        this.componentName = componentName;
        return this;
    }

    @Override
    public AbstractSpan start(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public SpanObjectV2.Builder transform() {
        SpanObjectV2.Builder spanBuilder = SpanObjectV2.newBuilder();
        spanBuilder.setSpanId(this.spanId);
        spanBuilder.setParentSpanId(this.parentSpanId);
        spanBuilder.setStartTime(this.startTime);
        spanBuilder.setEndTime(this.endTime);
        if (this.operationId != DictionaryUtil.nullValue()) {
            spanBuilder.setOperationNameId(this.operationId);
        } else {
            spanBuilder.setOperationName(this.operationName);
        }
        if (this.isEntry()) {
            spanBuilder.setSpanType(SpanType.Entry);
        } else if (this.isExit()) {
            spanBuilder.setSpanType(SpanType.Exit);
        } else {
            spanBuilder.setSpanType(SpanType.Local);
        }
        if (this.layer != null) {
            spanBuilder.setSpanLayerValue(this.layer.getCode());
        }
        if (this.componentId != DictionaryUtil.nullValue()) {
            spanBuilder.setComponentId(this.componentId);
        } else if (this.componentName != null) {
            spanBuilder.setComponent(this.componentName);
        }
        spanBuilder.setIsError(this.errorOccurred);
        if (this.tags != null) {
            for (TagValuePair tag : this.tags) {
                spanBuilder.addTags(tag.transform());
            }
        }
        if (this.logs != null) {
            for (LogDataEntity log : this.logs) {
                spanBuilder.addLogs(log.transform());
            }
        }
        if (this.refs != null) {
            for (TraceSegmentRef ref : this.refs) {
                spanBuilder.addRefs(ref.transform());
            }
        }
        return spanBuilder;
    }

    @Override
    public void ref(TraceSegmentRef ref) {
        if (this.refs == null) {
            this.refs = new LinkedList<TraceSegmentRef>();
        }
        if (!this.refs.contains(ref)) {
            this.refs.add(ref);
        }
    }

    @Override
    public AbstractSpan prepareForAsync() {
        this.context = ContextManager.awaitFinishAsync(this);
        this.isInAsyncMode = true;
        return this;
    }

    @Override
    public AbstractSpan asyncFinish() {
        if (!this.isInAsyncMode) {
            throw new RuntimeException("Span is not in async mode, please use '#prepareForAsync' to active.");
        }
        this.endTime = System.currentTimeMillis();
        this.context.asyncStop(this);
        return this;
    }
}

