/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.ids;

import org.apache.skywalking.apm.network.language.agent.UniqueId;

public class ID {
    private long part1;
    private long part2;
    private long part3;
    private String encoding;
    private boolean isValid;

    public ID(long part1, long part2, long part3) {
        this.part1 = part1;
        this.part2 = part2;
        this.part3 = part3;
        this.encoding = null;
        this.isValid = true;
    }

    public ID(String encodingString) {
        String[] idParts = encodingString.split("\\.", 3);
        this.isValid = true;
        for (int part = 0; part < 3; ++part) {
            try {
                if (part == 0) {
                    this.part1 = Long.parseLong(idParts[part]);
                    continue;
                }
                if (part == 1) {
                    this.part2 = Long.parseLong(idParts[part]);
                    continue;
                }
                this.part3 = Long.parseLong(idParts[part]);
                continue;
            }
            catch (NumberFormatException e) {
                this.isValid = false;
                break;
            }
        }
    }

    public String encode() {
        if (this.encoding == null) {
            this.encoding = this.toString();
        }
        return this.encoding;
    }

    public String toString() {
        return this.part1 + "." + this.part2 + '.' + this.part3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ID id = (ID)o;
        if (this.part1 != id.part1) {
            return false;
        }
        if (this.part2 != id.part2) {
            return false;
        }
        return this.part3 == id.part3;
    }

    public int hashCode() {
        int result = (int)(this.part1 ^ this.part1 >>> 32);
        result = 31 * result + (int)(this.part2 ^ this.part2 >>> 32);
        result = 31 * result + (int)(this.part3 ^ this.part3 >>> 32);
        return result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public UniqueId transform() {
        return UniqueId.newBuilder().addIdParts(this.part1).addIdParts(this.part2).addIdParts(this.part3).build();
    }
}

