/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.ids;

import java.util.Random;
import org.apache.skywalking.apm.agent.core.conf.RemoteDownstreamConfig;
import org.apache.skywalking.apm.agent.core.context.ids.ID;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;

public final class GlobalIdGenerator {
    private static final ThreadLocal<IDContext> THREAD_ID_SEQUENCE = new ThreadLocal<IDContext>(){

        @Override
        protected IDContext initialValue() {
            return new IDContext(System.currentTimeMillis(), 0);
        }
    };

    private GlobalIdGenerator() {
    }

    public static ID generate() {
        if (RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID == DictionaryUtil.nullValue()) {
            throw new IllegalStateException();
        }
        IDContext context = THREAD_ID_SEQUENCE.get();
        return new ID(RemoteDownstreamConfig.Agent.SERVICE_INSTANCE_ID, Thread.currentThread().getId(), context.nextSeq());
    }

    private static class IDContext {
        private long lastTimestamp;
        private short threadSeq;
        private long runRandomTimestamp;
        private int lastRandomValue;
        private Random random;

        private IDContext(long lastTimestamp, short threadSeq) {
            this.lastTimestamp = lastTimestamp;
            this.threadSeq = threadSeq;
        }

        private long nextSeq() {
            return this.timestamp() * 10000L + (long)this.nextThreadSeq();
        }

        private long timestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTimestamp) {
                if (this.random == null) {
                    this.random = new Random();
                }
                if (this.runRandomTimestamp != currentTimeMillis) {
                    this.lastRandomValue = this.random.nextInt();
                    this.runRandomTimestamp = currentTimeMillis;
                }
                return this.lastRandomValue;
            }
            this.lastTimestamp = currentTimeMillis;
            return this.lastTimestamp;
        }

        private short nextThreadSeq() {
            if (this.threadSeq == 10000) {
                this.threadSeq = 0;
            }
            short s = this.threadSeq;
            this.threadSeq = (short)(s + 1);
            return s;
        }
    }
}

