/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.AsyncSpan;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.TracingContextListener;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.EntrySpan;
import org.apache.skywalking.apm.agent.core.context.trace.ExitSpan;
import org.apache.skywalking.apm.agent.core.context.trace.LocalSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopExitSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopSpan;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.agent.core.context.trace.WithPeerInfo;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryManager;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.agent.core.dictionary.PossibleFound;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.sampling.SamplingService;
import org.apache.skywalking.apm.util.StringUtil;

public class TracingContext
implements AbstractTracerContext {
    private static final ILog logger = LogManager.getLogger(TracingContext.class);
    private long lastWarningTimestamp = 0L;
    private SamplingService samplingService;
    private TraceSegment segment;
    private LinkedList<AbstractSpan> activeSpanStack = new LinkedList();
    private int spanIdGenerator = 0;
    private volatile AtomicInteger asyncSpanCounter;
    private volatile boolean isRunningInAsyncMode = false;
    private volatile ReentrantLock asyncFinishLock;

    TracingContext() {
        this.segment = new TraceSegment();
        this.samplingService = ServiceManager.INSTANCE.findService(SamplingService.class);
    }

    @Override
    public void inject(ContextCarrier carrier) {
        int parentOperationId;
        int entryApplicationInstanceId;
        String operationName;
        int operationId;
        AbstractSpan span = this.activeSpan();
        if (!span.isExit()) {
            throw new IllegalStateException("Inject can be done only in Exit Span");
        }
        WithPeerInfo spanWithPeer = (WithPeerInfo)((Object)span);
        String peer = spanWithPeer.getPeer();
        int peerId = spanWithPeer.getPeerId();
        carrier.setTraceSegmentId(this.segment.getTraceSegmentId());
        carrier.setSpanId(span.getSpanId());
        carrier.setParentServiceInstanceId(this.segment.getApplicationInstanceId());
        if (DictionaryUtil.isNull(peerId)) {
            carrier.setPeerHost(peer);
        } else {
            carrier.setPeerId(peerId);
        }
        List<TraceSegmentRef> refs = this.segment.getRefs();
        if (refs != null && refs.size() > 0) {
            TraceSegmentRef ref = refs.get(0);
            operationId = ref.getEntryEndpointId();
            operationName = ref.getEntryEndpointName();
            entryApplicationInstanceId = ref.getEntryServiceInstanceId();
        } else {
            AbstractSpan firstSpan = this.first();
            operationId = firstSpan.getOperationId();
            operationName = firstSpan.getOperationName();
            entryApplicationInstanceId = this.segment.getApplicationInstanceId();
        }
        carrier.setEntryServiceInstanceId(entryApplicationInstanceId);
        if (operationId == DictionaryUtil.nullValue()) {
            if (!StringUtil.isEmpty(operationName)) {
                carrier.setEntryEndpointName(operationName);
            }
        } else {
            carrier.setEntryEndpointId(operationId);
        }
        if ((parentOperationId = this.first().getOperationId()) == DictionaryUtil.nullValue()) {
            carrier.setParentEndpointName(this.first().getOperationName());
        } else {
            carrier.setParentEndpointId(parentOperationId);
        }
        carrier.setDistributedTraceIds(this.segment.getRelatedGlobalTraces());
    }

    @Override
    public void extract(ContextCarrier carrier) {
        TraceSegmentRef ref = new TraceSegmentRef(carrier);
        this.segment.ref(ref);
        this.segment.relatedGlobalTraces(carrier.getDistributedTraceId());
        AbstractSpan span = this.activeSpan();
        if (span instanceof EntrySpan) {
            span.ref(ref);
        }
    }

    @Override
    public ContextSnapshot capture() {
        int entryApplicationInstanceId;
        String entryOperationName;
        int entryOperationId;
        List<TraceSegmentRef> refs = this.segment.getRefs();
        ContextSnapshot snapshot = new ContextSnapshot(this.segment.getTraceSegmentId(), this.activeSpan().getSpanId(), this.segment.getRelatedGlobalTraces());
        AbstractSpan firstSpan = this.first();
        if (refs != null && refs.size() > 0) {
            TraceSegmentRef ref = refs.get(0);
            entryOperationId = ref.getEntryEndpointId();
            entryOperationName = ref.getEntryEndpointName();
            entryApplicationInstanceId = ref.getEntryServiceInstanceId();
        } else {
            entryOperationId = firstSpan.getOperationId();
            entryOperationName = firstSpan.getOperationName();
            entryApplicationInstanceId = this.segment.getApplicationInstanceId();
        }
        snapshot.setEntryApplicationInstanceId(entryApplicationInstanceId);
        if (entryOperationId == DictionaryUtil.nullValue()) {
            if (!StringUtil.isEmpty(entryOperationName)) {
                snapshot.setEntryOperationName(entryOperationName);
            }
        } else {
            snapshot.setEntryOperationId(entryOperationId);
        }
        if (firstSpan.getOperationId() == DictionaryUtil.nullValue()) {
            snapshot.setParentOperationName(firstSpan.getOperationName());
        } else {
            snapshot.setParentOperationId(firstSpan.getOperationId());
        }
        return snapshot;
    }

    @Override
    public void continued(ContextSnapshot snapshot) {
        TraceSegmentRef segmentRef = new TraceSegmentRef(snapshot);
        this.segment.ref(segmentRef);
        this.activeSpan().ref(segmentRef);
        this.segment.relatedGlobalTraces(snapshot.getDistributedTraceId());
    }

    @Override
    public String getReadableGlobalTraceId() {
        return this.segment.getRelatedGlobalTraces().get(0).toString();
    }

    @Override
    public AbstractSpan createEntrySpan(final String operationName) {
        int parentSpanId;
        if (this.isLimitMechanismWorking()) {
            NoopSpan span = new NoopSpan();
            return this.push(span);
        }
        final AbstractSpan parentSpan = this.peek();
        int n = parentSpanId = parentSpan == null ? -1 : parentSpan.getSpanId();
        if (parentSpan != null && parentSpan.isEntry()) {
            AbstractTracingSpan entrySpan = (AbstractTracingSpan)DictionaryManager.findEndpointSection().findOnly(this.segment.getServiceId(), operationName).doInCondition(new PossibleFound.FoundAndObtain(){

                @Override
                public Object doProcess(int operationId) {
                    return parentSpan.setOperationId(operationId);
                }
            }, new PossibleFound.NotFoundAndObtain(){

                @Override
                public Object doProcess() {
                    return parentSpan.setOperationName(operationName);
                }
            });
            return entrySpan.start();
        }
        AbstractTracingSpan entrySpan = (AbstractTracingSpan)DictionaryManager.findEndpointSection().findOnly(this.segment.getServiceId(), operationName).doInCondition(new PossibleFound.FoundAndObtain(){

            @Override
            public Object doProcess(int operationId) {
                return new EntrySpan(TracingContext.this.spanIdGenerator++, parentSpanId, operationId);
            }
        }, new PossibleFound.NotFoundAndObtain(){

            @Override
            public Object doProcess() {
                return new EntrySpan(TracingContext.this.spanIdGenerator++, parentSpanId, operationName);
            }
        });
        entrySpan.start();
        return this.push(entrySpan);
    }

    @Override
    public AbstractSpan createLocalSpan(String operationName) {
        if (this.isLimitMechanismWorking()) {
            NoopSpan span = new NoopSpan();
            return this.push(span);
        }
        AbstractSpan parentSpan = this.peek();
        int parentSpanId = parentSpan == null ? -1 : parentSpan.getSpanId();
        LocalSpan span = new LocalSpan(this.spanIdGenerator++, parentSpanId, operationName);
        span.start();
        return this.push(span);
    }

    @Override
    public AbstractSpan createExitSpan(final String operationName, final String remotePeer) {
        AbstractSpan exitSpan;
        AbstractSpan parentSpan = this.peek();
        if (parentSpan != null && parentSpan.isExit()) {
            exitSpan = parentSpan;
        } else {
            final int parentSpanId = parentSpan == null ? -1 : parentSpan.getSpanId();
            exitSpan = (AbstractSpan)DictionaryManager.findNetworkAddressSection().find(remotePeer).doInCondition(new PossibleFound.FoundAndObtain(){

                @Override
                public Object doProcess(final int peerId) {
                    if (TracingContext.this.isLimitMechanismWorking()) {
                        return new NoopExitSpan(peerId);
                    }
                    return DictionaryManager.findEndpointSection().findOnly(TracingContext.this.segment.getServiceId(), operationName).doInCondition(new PossibleFound.FoundAndObtain(){

                        @Override
                        public Object doProcess(int operationId) {
                            return new ExitSpan(TracingContext.this.spanIdGenerator++, parentSpanId, operationId, peerId);
                        }
                    }, new PossibleFound.NotFoundAndObtain(){

                        @Override
                        public Object doProcess() {
                            return new ExitSpan(TracingContext.this.spanIdGenerator++, parentSpanId, operationName, peerId);
                        }
                    });
                }
            }, new PossibleFound.NotFoundAndObtain(){

                @Override
                public Object doProcess() {
                    if (TracingContext.this.isLimitMechanismWorking()) {
                        return new NoopExitSpan(remotePeer);
                    }
                    return DictionaryManager.findEndpointSection().findOnly(TracingContext.this.segment.getServiceId(), operationName).doInCondition(new PossibleFound.FoundAndObtain(){

                        @Override
                        public Object doProcess(int operationId) {
                            return new ExitSpan(TracingContext.this.spanIdGenerator++, parentSpanId, operationId, remotePeer);
                        }
                    }, new PossibleFound.NotFoundAndObtain(){

                        @Override
                        public Object doProcess() {
                            return new ExitSpan(TracingContext.this.spanIdGenerator++, parentSpanId, operationName, remotePeer);
                        }
                    });
                }
            });
            this.push(exitSpan);
        }
        exitSpan.start();
        return exitSpan;
    }

    @Override
    public AbstractSpan activeSpan() {
        AbstractSpan span = this.peek();
        if (span == null) {
            throw new IllegalStateException("No active span.");
        }
        return span;
    }

    @Override
    public boolean stopSpan(AbstractSpan span) {
        AbstractSpan lastSpan = this.peek();
        if (lastSpan == span) {
            if (lastSpan instanceof AbstractTracingSpan) {
                AbstractTracingSpan toFinishSpan = (AbstractTracingSpan)lastSpan;
                if (toFinishSpan.finish(this.segment)) {
                    this.pop();
                }
            } else {
                this.pop();
            }
        } else {
            throw new IllegalStateException("Stopping the unexpected span = " + span);
        }
        if (this.checkFinishConditions()) {
            this.finish();
        }
        return this.activeSpanStack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractTracerContext awaitFinishAsync() {
        if (!this.isRunningInAsyncMode) {
            TracingContext tracingContext = this;
            synchronized (tracingContext) {
                if (!this.isRunningInAsyncMode) {
                    this.asyncFinishLock = new ReentrantLock();
                    this.asyncSpanCounter = new AtomicInteger(0);
                    this.isRunningInAsyncMode = true;
                }
            }
        }
        this.asyncSpanCounter.addAndGet(1);
        return this;
    }

    @Override
    public void asyncStop(AsyncSpan span) {
        this.asyncSpanCounter.addAndGet(-1);
        if (this.checkFinishConditions()) {
            this.finish();
        }
    }

    private boolean checkFinishConditions() {
        if (this.isRunningInAsyncMode) {
            this.asyncFinishLock.lock();
        }
        try {
            if (this.activeSpanStack.isEmpty() && (!this.isRunningInAsyncMode || this.asyncSpanCounter.get() == 0)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (this.isRunningInAsyncMode) {
                this.asyncFinishLock.unlock();
            }
        }
        return false;
    }

    private void finish() {
        TraceSegment finishedSegment = this.segment.finish(this.isLimitMechanismWorking());
        if (!this.segment.hasRef() && this.segment.isSingleSpanSegment() && !this.samplingService.trySampling()) {
            finishedSegment.setIgnore(true);
        }
        ListenerManager.notifyFinish(finishedSegment);
    }

    private AbstractSpan pop() {
        return this.activeSpanStack.removeLast();
    }

    private AbstractSpan push(AbstractSpan span) {
        this.activeSpanStack.addLast(span);
        return span;
    }

    private AbstractSpan peek() {
        if (this.activeSpanStack.isEmpty()) {
            return null;
        }
        return this.activeSpanStack.getLast();
    }

    private AbstractSpan first() {
        return this.activeSpanStack.getFirst();
    }

    private boolean isLimitMechanismWorking() {
        if (this.spanIdGenerator >= Config.Agent.SPAN_LIMIT_PER_SEGMENT) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.lastWarningTimestamp > 30000L) {
                logger.warn(new RuntimeException("Shadow tracing context. Thread dump"), "More than {} spans required to create", Config.Agent.SPAN_LIMIT_PER_SEGMENT);
                this.lastWarningTimestamp = currentTimeMillis;
            }
            return true;
        }
        return false;
    }

    public static class ListenerManager {
        private static List<TracingContextListener> LISTENERS = new LinkedList<TracingContextListener>();

        public static synchronized void add(TracingContextListener listener) {
            LISTENERS.add(listener);
        }

        static void notifyFinish(TraceSegment finishedSegment) {
            for (TracingContextListener listener : LISTENERS) {
                listener.afterFinished(finishedSegment);
            }
        }

        public static synchronized void remove(TracingContextListener listener) {
            LISTENERS.remove(listener);
        }
    }
}

