/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.AsyncSpan;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.IgnoreTracerContextListener;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopSpan;

public class IgnoredTracerContext
implements AbstractTracerContext {
    private static final NoopSpan NOOP_SPAN = new NoopSpan();
    private int stackDepth = 0;

    @Override
    public void inject(ContextCarrier carrier) {
    }

    @Override
    public void extract(ContextCarrier carrier) {
    }

    @Override
    public ContextSnapshot capture() {
        return new ContextSnapshot(null, -1, null);
    }

    @Override
    public void continued(ContextSnapshot snapshot) {
    }

    @Override
    public String getReadableGlobalTraceId() {
        return "[Ignored Trace]";
    }

    @Override
    public AbstractSpan createEntrySpan(String operationName) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan createLocalSpan(String operationName) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan createExitSpan(String operationName, String remotePeer) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan activeSpan() {
        return NOOP_SPAN;
    }

    @Override
    public boolean stopSpan(AbstractSpan span) {
        --this.stackDepth;
        if (this.stackDepth == 0) {
            ListenerManager.notifyFinish(this);
        }
        return this.stackDepth == 0;
    }

    @Override
    public AbstractTracerContext awaitFinishAsync() {
        return this;
    }

    @Override
    public void asyncStop(AsyncSpan span) {
    }

    public static class ListenerManager {
        private static List<IgnoreTracerContextListener> LISTENERS = new LinkedList<IgnoreTracerContextListener>();

        public static synchronized void add(IgnoreTracerContextListener listener) {
            LISTENERS.add(listener);
        }

        static void notifyFinish(IgnoredTracerContext ignoredTracerContext) {
            for (IgnoreTracerContextListener listener : LISTENERS) {
                listener.afterFinished(ignoredTracerContext);
            }
        }

        public static synchronized void remove(IgnoreTracerContextListener listener) {
            LISTENERS.remove(listener);
        }
    }
}

