/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.List;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.ids.ID;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;

public class ContextSnapshot {
    private ID traceSegmentId;
    private int spanId = -1;
    private String entryOperationName;
    private String parentOperationName;
    private DistributedTraceId primaryDistributedTraceId;
    private int entryApplicationInstanceId = DictionaryUtil.nullValue();

    ContextSnapshot(ID traceSegmentId, int spanId, List<DistributedTraceId> distributedTraceIds) {
        this.traceSegmentId = traceSegmentId;
        this.spanId = spanId;
        if (distributedTraceIds != null) {
            this.primaryDistributedTraceId = distributedTraceIds.get(0);
        }
    }

    public void setEntryOperationName(String entryOperationName) {
        this.entryOperationName = "#" + entryOperationName;
    }

    public void setEntryOperationId(int entryOperationId) {
        this.entryOperationName = entryOperationId + "";
    }

    public void setParentOperationName(String parentOperationName) {
        this.parentOperationName = "#" + parentOperationName;
    }

    public void setParentOperationId(int parentOperationId) {
        this.parentOperationName = parentOperationId + "";
    }

    public DistributedTraceId getDistributedTraceId() {
        return this.primaryDistributedTraceId;
    }

    public ID getTraceSegmentId() {
        return this.traceSegmentId;
    }

    public int getSpanId() {
        return this.spanId;
    }

    public String getParentOperationName() {
        return this.parentOperationName;
    }

    public boolean isValid() {
        return this.traceSegmentId != null && this.spanId > -1 && this.entryApplicationInstanceId != DictionaryUtil.nullValue() && this.primaryDistributedTraceId != null;
    }

    public String getEntryOperationName() {
        return this.entryOperationName;
    }

    public void setEntryApplicationInstanceId(int entryApplicationInstanceId) {
        this.entryApplicationInstanceId = entryApplicationInstanceId;
    }

    public int getEntryApplicationInstanceId() {
        return this.entryApplicationInstanceId;
    }

    public boolean isFromCurrent() {
        return this.traceSegmentId.equals(ContextManager.capture().getTraceSegmentId());
    }
}

