/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.io.Serializable;
import java.util.List;
import org.apache.skywalking.apm.agent.core.base64.Base64;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.CarrierItemHead;
import org.apache.skywalking.apm.agent.core.context.SW3CarrierItem;
import org.apache.skywalking.apm.agent.core.context.SW6CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.context.ids.ID;
import org.apache.skywalking.apm.agent.core.context.ids.PropagatedTraceId;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.util.StringUtil;

public class ContextCarrier
implements Serializable {
    private ID traceSegmentId;
    private int spanId = -1;
    private int parentServiceInstanceId = DictionaryUtil.nullValue();
    private int entryServiceInstanceId = DictionaryUtil.nullValue();
    private String peerHost;
    private String entryEndpointName;
    private String parentEndpointName;
    private DistributedTraceId primaryDistributedTraceId;

    public CarrierItem items() {
        CarrierItemHead head;
        if (Config.Agent.ACTIVE_V2_HEADER && Config.Agent.ACTIVE_V1_HEADER) {
            SW3CarrierItem carrierItem = new SW3CarrierItem(this, null);
            SW6CarrierItem sw6CarrierItem = new SW6CarrierItem(this, carrierItem);
            head = new CarrierItemHead(sw6CarrierItem);
        } else if (Config.Agent.ACTIVE_V2_HEADER) {
            SW6CarrierItem sw6CarrierItem = new SW6CarrierItem(this, null);
            head = new CarrierItemHead(sw6CarrierItem);
        } else if (Config.Agent.ACTIVE_V1_HEADER) {
            SW3CarrierItem carrierItem = new SW3CarrierItem(this, null);
            head = new CarrierItemHead(carrierItem);
        } else {
            throw new IllegalArgumentException("At least active v1 or v2 header.");
        }
        return head;
    }

    String serialize(HeaderVersion version) {
        if (this.isValid(version)) {
            if (HeaderVersion.v1.equals((Object)version)) {
                if (Config.Agent.ACTIVE_V1_HEADER) {
                    return StringUtil.join('|', this.getTraceSegmentId().encode(), this.getSpanId() + "", this.getParentServiceInstanceId() + "", this.getEntryServiceInstanceId() + "", this.getPeerHost(), this.getEntryEndpointName(), this.getParentEndpointName(), this.getPrimaryDistributedTraceId().encode());
                }
                return "";
            }
            if (Config.Agent.ACTIVE_V2_HEADER) {
                return StringUtil.join('-', "1", Base64.encode(this.getPrimaryDistributedTraceId().encode()), Base64.encode(this.getTraceSegmentId().encode()), this.getSpanId() + "", this.getParentServiceInstanceId() + "", this.getEntryServiceInstanceId() + "", Base64.encode(this.getPeerHost()), Base64.encode(this.getEntryEndpointName()), Base64.encode(this.getParentEndpointName()));
            }
            return "";
        }
        return "";
    }

    ContextCarrier deserialize(String text, HeaderVersion version) {
        if (text != null) {
            if (this.isValid(HeaderVersion.v1) || this.isValid(HeaderVersion.v2)) {
                return this;
            }
            if (HeaderVersion.v1.equals((Object)version)) {
                String[] parts = text.split("\\|", 8);
                if (parts.length == 8) {
                    try {
                        this.traceSegmentId = new ID(parts[0]);
                        this.spanId = Integer.parseInt(parts[1]);
                        this.parentServiceInstanceId = Integer.parseInt(parts[2]);
                        this.entryServiceInstanceId = Integer.parseInt(parts[3]);
                        this.peerHost = parts[4];
                        this.entryEndpointName = parts[5];
                        this.parentEndpointName = parts[6];
                        this.primaryDistributedTraceId = new PropagatedTraceId(parts[7]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (HeaderVersion.v2.equals((Object)version)) {
                String[] parts = text.split("\\-", 9);
                if (parts.length == 9) {
                    try {
                        this.primaryDistributedTraceId = new PropagatedTraceId(Base64.decode2UTFString(parts[1]));
                        this.traceSegmentId = new ID(Base64.decode2UTFString(parts[2]));
                        this.spanId = Integer.parseInt(parts[3]);
                        this.parentServiceInstanceId = Integer.parseInt(parts[4]);
                        this.entryServiceInstanceId = Integer.parseInt(parts[5]);
                        this.peerHost = Base64.decode2UTFString(parts[6]);
                        this.entryEndpointName = Base64.decode2UTFString(parts[7]);
                        this.parentEndpointName = Base64.decode2UTFString(parts[8]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                throw new IllegalArgumentException("Unimplemented header version." + (Object)((Object)version));
            }
        }
        return this;
    }

    public boolean isValid() {
        return this.isValid(HeaderVersion.v2) || this.isValid(HeaderVersion.v1);
    }

    boolean isValid(HeaderVersion version) {
        if (HeaderVersion.v1.equals((Object)version)) {
            return this.traceSegmentId != null && this.traceSegmentId.isValid() && this.getSpanId() > -1 && this.parentServiceInstanceId != DictionaryUtil.nullValue() && this.entryServiceInstanceId != DictionaryUtil.nullValue() && !StringUtil.isEmpty(this.peerHost) && !StringUtil.isEmpty(this.entryEndpointName) && !StringUtil.isEmpty(this.parentEndpointName) && this.primaryDistributedTraceId != null;
        }
        if (HeaderVersion.v2.equals((Object)version)) {
            return this.traceSegmentId != null && this.traceSegmentId.isValid() && this.getSpanId() > -1 && this.parentServiceInstanceId != DictionaryUtil.nullValue() && this.entryServiceInstanceId != DictionaryUtil.nullValue() && !StringUtil.isEmpty(this.peerHost) && this.primaryDistributedTraceId != null;
        }
        throw new IllegalArgumentException("Unimplemented header version." + (Object)((Object)version));
    }

    public String getEntryEndpointName() {
        return this.entryEndpointName;
    }

    void setEntryEndpointName(String entryEndpointName) {
        this.entryEndpointName = '#' + entryEndpointName;
    }

    void setEntryEndpointId(int entryOperationId) {
        this.entryEndpointName = entryOperationId + "";
    }

    void setParentEndpointName(String parentEndpointName) {
        this.parentEndpointName = '#' + parentEndpointName;
    }

    void setParentEndpointId(int parentOperationId) {
        this.parentEndpointName = parentOperationId + "";
    }

    public ID getTraceSegmentId() {
        return this.traceSegmentId;
    }

    public int getSpanId() {
        return this.spanId;
    }

    void setTraceSegmentId(ID traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    void setSpanId(int spanId) {
        this.spanId = spanId;
    }

    public int getParentServiceInstanceId() {
        return this.parentServiceInstanceId;
    }

    void setParentServiceInstanceId(int parentServiceInstanceId) {
        this.parentServiceInstanceId = parentServiceInstanceId;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    void setPeerHost(String peerHost) {
        this.peerHost = '#' + peerHost;
    }

    void setPeerId(int peerId) {
        this.peerHost = peerId + "";
    }

    public DistributedTraceId getDistributedTraceId() {
        return this.primaryDistributedTraceId;
    }

    public void setDistributedTraceIds(List<DistributedTraceId> distributedTraceIds) {
        this.primaryDistributedTraceId = distributedTraceIds.get(0);
    }

    private DistributedTraceId getPrimaryDistributedTraceId() {
        return this.primaryDistributedTraceId;
    }

    public String getParentEndpointName() {
        return this.parentEndpointName;
    }

    public int getEntryServiceInstanceId() {
        return this.entryServiceInstanceId;
    }

    public void setEntryServiceInstanceId(int entryServiceInstanceId) {
        this.entryServiceInstanceId = entryServiceInstanceId;
    }

    public static enum HeaderVersion {
        v1,
        v2;

    }
}

