/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.boot;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceConflictException;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.loader.AgentClassLoader;

public enum ServiceManager {
    INSTANCE;

    private static final ILog logger;
    private Map<Class, BootService> bootedServices = Collections.emptyMap();

    public void boot() {
        this.bootedServices = this.loadAllServices();
        this.prepare();
        this.startup();
        this.onComplete();
    }

    public void shutdown() {
        for (BootService service : this.bootedServices.values()) {
            try {
                service.shutdown();
            }
            catch (Throwable e) {
                logger.error(e, "ServiceManager try to shutdown [{}] fail.", service.getClass().getName());
            }
        }
    }

    private Map<Class, BootService> loadAllServices() {
        LinkedHashMap<Class, BootService> bootedServices = new LinkedHashMap<Class, BootService>();
        LinkedList<BootService> allServices = new LinkedList<BootService>();
        this.load(allServices);
        for (BootService bootService : allServices) {
            Class<?> bootServiceClass = bootService.getClass();
            boolean isDefaultImplementor = bootServiceClass.isAnnotationPresent(DefaultImplementor.class);
            if (isDefaultImplementor) {
                if (bootedServices.containsKey(bootServiceClass)) continue;
                bootedServices.put(bootServiceClass, bootService);
                continue;
            }
            OverrideImplementor overrideImplementor = bootServiceClass.getAnnotation(OverrideImplementor.class);
            if (overrideImplementor == null) {
                if (!bootedServices.containsKey(bootServiceClass)) {
                    bootedServices.put(bootServiceClass, bootService);
                    continue;
                }
                throw new ServiceConflictException("Duplicate service define for :" + bootServiceClass);
            }
            Class<? extends BootService> targetService = overrideImplementor.value();
            if (bootedServices.containsKey(targetService)) {
                boolean presentDefault = ((BootService)bootedServices.get(targetService)).getClass().isAnnotationPresent(DefaultImplementor.class);
                if (presentDefault) {
                    bootedServices.put(targetService, bootService);
                    continue;
                }
                throw new ServiceConflictException("Service " + bootServiceClass + " overrides conflict, exist more than one service want to override :" + targetService);
            }
            bootedServices.put(targetService, bootService);
        }
        return bootedServices;
    }

    private void prepare() {
        for (BootService service : this.bootedServices.values()) {
            try {
                service.prepare();
            }
            catch (Throwable e) {
                logger.error(e, "ServiceManager try to pre-start [{}] fail.", service.getClass().getName());
            }
        }
    }

    private void startup() {
        for (BootService service : this.bootedServices.values()) {
            try {
                service.boot();
            }
            catch (Throwable e) {
                logger.error(e, "ServiceManager try to start [{}] fail.", service.getClass().getName());
            }
        }
    }

    private void onComplete() {
        for (BootService service : this.bootedServices.values()) {
            try {
                service.onComplete();
            }
            catch (Throwable e) {
                logger.error(e, "Service [{}] AfterBoot process fails.", service.getClass().getName());
            }
        }
    }

    public <T extends BootService> T findService(Class<T> serviceClass) {
        return (T)this.bootedServices.get(serviceClass);
    }

    void load(List<BootService> allServices) {
        Iterator<BootService> iterator = ServiceLoader.load(BootService.class, AgentClassLoader.getDefault()).iterator();
        while (iterator.hasNext()) {
            allServices.add(iterator.next());
        }
    }

    static {
        logger = LogManager.getLogger(ServiceManager.class);
    }
}

