/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent;

import java.lang.instrument.Instrumentation;
import java.util.List;
import org.apache.skywalking.apm.agent.InstrumentDebuggingClass;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.ConfigNotFoundException;
import org.apache.skywalking.apm.agent.core.conf.SnifferConfigInitializer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.AbstractClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.EnhanceContext;
import org.apache.skywalking.apm.agent.core.plugin.PluginBootstrap;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.PluginFinder;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.ByteBuddy;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.NamedElement;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.DynamicType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.JavaModule;

public class SkyWalkingAgent {
    private static final ILog logger = LogManager.getLogger(SkyWalkingAgent.class);

    public static void premain(String agentArgs, Instrumentation instrumentation) throws PluginException {
        PluginFinder pluginFinder;
        try {
            SnifferConfigInitializer.initialize(agentArgs);
            pluginFinder = new PluginFinder(new PluginBootstrap().loadPlugins());
        }
        catch (ConfigNotFoundException ce) {
            logger.error(ce, "Skywalking agent could not find config. Shutting down.", new Object[0]);
            return;
        }
        catch (AgentPackageNotFoundException ape) {
            logger.error(ape, "Locate agent.jar failure. Shutting down.", new Object[0]);
            return;
        }
        catch (Exception e) {
            logger.error(e, "Skywalking agent initialized failure. Shutting down.", new Object[0]);
            return;
        }
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(Config.Agent.IS_OPEN_DEBUGGING_CLASS));
        new AgentBuilder.Default(byteBuddy).ignore(ElementMatchers.nameStartsWith("org.apache.skywalking.apm.dependencies.net.bytebuddy.").or(ElementMatchers.nameStartsWith("org.slf4j.")).or(ElementMatchers.nameStartsWith("org.apache.logging.")).or(ElementMatchers.nameStartsWith("org.groovy.")).or(ElementMatchers.nameContains("javassist")).or(ElementMatchers.nameContains(".asm.")).or(ElementMatchers.nameStartsWith("sun.reflect")).or(SkyWalkingAgent.allSkyWalkingAgentExcludeToolkit()).or(ElementMatchers.isSynthetic())).type(pluginFinder.buildMatch()).transform(new Transformer(pluginFinder)).with(new Listener()).installOn(instrumentation);
        try {
            ServiceManager.INSTANCE.boot();
        }
        catch (Exception e) {
            logger.error(e, "Skywalking agent boot failure.", new Object[0]);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceManager.INSTANCE.shutdown();
            }
        }, "skywalking service shutdown thread"));
    }

    private static ElementMatcher.Junction<NamedElement> allSkyWalkingAgentExcludeToolkit() {
        return ElementMatchers.nameStartsWith("org.apache.skywalking.").and(ElementMatchers.not(ElementMatchers.nameStartsWith("org.apache.skywalking.apm.toolkit.")));
    }

    private static class Listener
    implements AgentBuilder.Listener {
        private Listener() {
        }

        @Override
        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        @Override
        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            if (logger.isDebugEnable()) {
                logger.debug("On Transformation class {}.", typeDescription.getName());
            }
            InstrumentDebuggingClass.INSTANCE.log(typeDescription, dynamicType);
        }

        @Override
        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        @Override
        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            logger.error("Enhance class " + typeName + " error.", throwable);
        }

        @Override
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    private static class Transformer
    implements AgentBuilder.Transformer {
        private PluginFinder pluginFinder;

        Transformer(PluginFinder pluginFinder) {
            this.pluginFinder = pluginFinder;
        }

        @Override
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            List<AbstractClassEnhancePluginDefine> pluginDefines = this.pluginFinder.find(typeDescription);
            if (pluginDefines.size() > 0) {
                DynamicType.Builder<?> newBuilder = builder;
                EnhanceContext context = new EnhanceContext();
                for (AbstractClassEnhancePluginDefine define : pluginDefines) {
                    DynamicType.Builder<?> possibleNewBuilder = define.define(typeDescription, newBuilder, classLoader, context);
                    if (possibleNewBuilder == null) continue;
                    newBuilder = possibleNewBuilder;
                }
                if (context.isEnhanced()) {
                    logger.debug("Finish the prepare stage for {}.", typeDescription.getName());
                }
                return newBuilder;
            }
            logger.debug("Matched class {}, but ignore by finding mechanism.", typeDescription.getTypeName());
            return builder;
        }
    }
}

