/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent;

import java.io.File;
import java.io.IOException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.DynamicType;

public enum InstrumentDebuggingClass {
    INSTANCE;

    private static final ILog logger;
    private File debuggingClassesRootPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(TypeDescription typeDescription, DynamicType dynamicType) {
        if (!Config.Agent.IS_OPEN_DEBUGGING_CLASS) {
            return;
        }
        InstrumentDebuggingClass instrumentDebuggingClass = INSTANCE;
        synchronized (instrumentDebuggingClass) {
            try {
                if (this.debuggingClassesRootPath == null) {
                    try {
                        this.debuggingClassesRootPath = new File(AgentPackagePath.getPath(), "/debugging");
                        if (!this.debuggingClassesRootPath.exists()) {
                            this.debuggingClassesRootPath.mkdir();
                        }
                    }
                    catch (AgentPackageNotFoundException e) {
                        logger.error(e, "Can't find the root path for creating /debugging folder.", new Object[0]);
                    }
                }
                try {
                    dynamicType.saveIn(this.debuggingClassesRootPath);
                }
                catch (IOException e) {
                    logger.error(e, "Can't save class {} to file." + typeDescription.getActualName(), new Object[0]);
                }
            }
            catch (Throwable t) {
                logger.error(t, "Save debugging classes fail.", new Object[0]);
            }
        }
    }

    static {
        logger = LogManager.getLogger(InstrumentDebuggingClass.class);
    }
}

