/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.apollo;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.apollo.ApolloConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.apollo.ApolloConfigurationCenterSettings;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;

public class ApolloConfigurationProvider
extends AbstractConfigurationProvider {
    private final ApolloConfigurationCenterSettings settings = new ApolloConfigurationCenterSettings();

    public String name() {
        return "apollo";
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.settings;
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        String env;
        String appId;
        String apolloMeta;
        String apolloCluster = this.settings.getApolloCluster();
        if (!Strings.isNullOrEmpty((String)apolloCluster)) {
            System.setProperty("apollo.cluster", apolloCluster);
        }
        if (!Strings.isNullOrEmpty((String)(apolloMeta = this.settings.getApolloMeta()))) {
            System.setProperty("apollo.meta", apolloMeta);
        }
        if (!Strings.isNullOrEmpty((String)(appId = this.settings.getAppId()))) {
            System.setProperty("app.id", appId);
        }
        if (!Strings.isNullOrEmpty((String)(env = this.settings.getApolloEnv()))) {
            System.setProperty("env", env);
        }
        return new ApolloConfigWatcherRegister(this.settings);
    }
}

