/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.activemq;

import java.lang.reflect.Method;
import javax.jms.Message;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ActiveMQProducerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "ActiveMQ/";
    public static final String PRODUCER_OPERATE_NAME_SUFFIX = "/Producer";
    public static final byte QUEUE_TYPE = 1;
    public static final byte TOPIC_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 6;
    public static final byte TEMP_QUEUE_TYPE = 5;

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ContextCarrier contextCarrier = new ContextCarrier();
        ActiveMQDestination activeMQDestination = (ActiveMQDestination)allArguments[0];
        Message message = (Message)allArguments[1];
        String url = (String)objInst.getSkyWalkingDynamicField();
        AbstractSpan activeSpan = null;
        if (activeMQDestination.getDestinationType() == 1 || activeMQDestination.getDestinationType() == 5) {
            activeSpan = ContextManager.createExitSpan((String)("ActiveMQ/Queue/" + activeMQDestination.getPhysicalName() + PRODUCER_OPERATE_NAME_SUFFIX), (ContextCarrier)contextCarrier, (String)url);
            Tags.MQ_BROKER.set(activeSpan, url);
            Tags.MQ_QUEUE.set(activeSpan, activeMQDestination.getPhysicalName());
        } else if (activeMQDestination.getDestinationType() == 2 || activeMQDestination.getDestinationType() == 6) {
            activeSpan = ContextManager.createExitSpan((String)("ActiveMQ/Topic/" + activeMQDestination.getPhysicalName() + PRODUCER_OPERATE_NAME_SUFFIX), (ContextCarrier)contextCarrier, (String)url);
            Tags.MQ_BROKER.set(activeSpan, url);
            Tags.MQ_TOPIC.set(activeSpan, activeMQDestination.getPhysicalName());
        }
        SpanLayer.asMQ(activeSpan);
        activeSpan.setComponent((Component)ComponentsDefine.ACTIVEMQ_PRODUCER);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            message.setStringProperty(next.getHeadKey(), next.getHeadValue());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

