/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.skywalking.apm.network.common.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.IdExchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanIdExchanger
implements IdExchanger<SpanDecorator> {
    private static final Logger logger = LoggerFactory.getLogger(SpanIdExchanger.class);
    private static SpanIdExchanger EXCHANGER;
    private final ServiceInventoryCache serviceInventoryCacheDAO;
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final IEndpointInventoryRegister endpointInventoryRegister;
    private final INetworkAddressInventoryRegister networkAddressInventoryRegister;
    private final IComponentLibraryCatalogService componentLibraryCatalogService;

    public static SpanIdExchanger getInstance(ModuleManager moduleManager) {
        if (EXCHANGER == null) {
            EXCHANGER = new SpanIdExchanger(moduleManager);
        }
        return EXCHANGER;
    }

    private SpanIdExchanger(ModuleManager moduleManager) {
        this.serviceInventoryCacheDAO = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
        this.endpointInventoryRegister = (IEndpointInventoryRegister)moduleManager.find("core").provider().getService(IEndpointInventoryRegister.class);
        this.networkAddressInventoryRegister = (INetworkAddressInventoryRegister)moduleManager.find("core").provider().getService(INetworkAddressInventoryRegister.class);
        this.componentLibraryCatalogService = (IComponentLibraryCatalogService)moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
    }

    @Override
    public boolean exchange(SpanDecorator standardBuilder, int serviceId) {
        int peerId;
        boolean exchanged = true;
        if (standardBuilder.getComponentId() == 0 && !Strings.isNullOrEmpty((String)standardBuilder.getComponent())) {
            int componentId = this.componentLibraryCatalogService.getComponentId(standardBuilder.getComponent());
            if (componentId == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("component: {} in service: {} exchange failed", (Object)standardBuilder.getComponent(), (Object)serviceId);
                }
                exchanged = false;
            } else {
                standardBuilder.toBuilder();
                standardBuilder.setComponentId(componentId);
                standardBuilder.setComponent("");
            }
        }
        if ((peerId = standardBuilder.getPeerId()) == 0 && !Strings.isNullOrEmpty((String)standardBuilder.getPeer())) {
            peerId = this.networkAddressInventoryRegister.getOrCreate(standardBuilder.getPeer(), this.buildServiceProperties(standardBuilder));
            if (peerId == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("peer: {} in service: {} exchange failed", (Object)standardBuilder.getPeer(), (Object)serviceId);
                }
                exchanged = false;
            } else {
                standardBuilder.toBuilder();
                standardBuilder.setPeerId(peerId);
                standardBuilder.setPeer("");
            }
        }
        if (peerId != 0) {
            int spanLayerValue = standardBuilder.getSpanLayerValue();
            NodeType nodeType = NodeType.fromSpanLayerValue((int)spanLayerValue);
            this.networkAddressInventoryRegister.update(peerId, nodeType);
            JsonObject properties = null;
            ServiceInventory newServiceInventory = this.serviceInventoryCacheDAO.get(this.serviceInventoryCacheDAO.getServiceId(peerId));
            if (SpanLayer.Database.equals((Object)standardBuilder.getSpanLayer()) && !newServiceInventory.hasProperties()) {
                properties = this.buildServiceProperties(standardBuilder);
            }
            this.serviceInventoryRegister.update(newServiceInventory.getSequence(), nodeType, properties);
        }
        if (standardBuilder.getOperationNameId() == 0) {
            String endpointName = Strings.isNullOrEmpty((String)standardBuilder.getOperationName()) ? "{domain}" : standardBuilder.getOperationName();
            int endpointId = this.endpointInventoryRegister.getOrCreate(serviceId, endpointName, DetectPoint.fromSpanType((SpanType)standardBuilder.getSpanType()));
            if (endpointId == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("endpoint name: {} from service id: {} exchange failed", (Object)endpointName, (Object)serviceId);
                }
                exchanged = false;
            } else {
                standardBuilder.toBuilder();
                standardBuilder.setOperationNameId(endpointId);
                standardBuilder.setOperationName("");
            }
        }
        return exchanged;
    }

    private JsonObject buildServiceProperties(SpanDecorator standardBuilder) {
        JsonObject properties = new JsonObject();
        if (SpanLayer.Database.equals((Object)standardBuilder.getSpanLayer())) {
            List<KeyStringValuePair> tags = standardBuilder.getAllTags();
            tags.forEach(tag -> {
                if ("db.type".equals(tag.getKey())) {
                    properties.addProperty("type", tag.getValue());
                } else if ("db.instance".equals(tag.getKey())) {
                    properties.addProperty("instance", tag.getValue());
                }
            });
            int id = standardBuilder.getComponentId();
            String componentName = id != 0 ? this.componentLibraryCatalogService.getServerNameBasedOnComponent(id) : "UNKNOWN";
            properties.addProperty("database", componentName);
        }
        return properties;
    }
}

