/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.segment;

import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.source.Segment;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SegmentCoreInfo;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.EntrySpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.FirstSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.GlobalTraceIdsListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListenerFactory;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.segment.TraceSegmentSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentSpanListener
implements FirstSpanListener,
EntrySpanListener,
GlobalTraceIdsListener {
    private static final Logger logger = LoggerFactory.getLogger(SegmentSpanListener.class);
    private final SourceReceiver sourceReceiver;
    private final TraceSegmentSampler sampler;
    private final Segment segment = new Segment();
    private final EndpointInventoryCache serviceNameCacheService;
    private SAMPLE_STATUS sampleStatus = SAMPLE_STATUS.UNKNOWN;
    private int entryEndpointId = 0;
    private int firstEndpointId = 0;

    private SegmentSpanListener(ModuleManager moduleManager, TraceSegmentSampler sampler) {
        this.sampler = sampler;
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.serviceNameCacheService = (EndpointInventoryCache)moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
    }

    @Override
    public boolean containsPoint(SpanListener.Point point) {
        return SpanListener.Point.First.equals((Object)point) || SpanListener.Point.Entry.equals((Object)point) || SpanListener.Point.TraceIds.equals((Object)point);
    }

    @Override
    public void parseFirst(SpanDecorator spanDecorator, SegmentCoreInfo segmentCoreInfo) {
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            return;
        }
        long timeBucket = TimeBucket.getSecondTimeBucket((long)segmentCoreInfo.getStartTime());
        this.segment.setSegmentId(segmentCoreInfo.getSegmentId());
        this.segment.setServiceId(segmentCoreInfo.getServiceId());
        this.segment.setServiceInstanceId(segmentCoreInfo.getServiceInstanceId());
        this.segment.setLatency((int)(segmentCoreInfo.getEndTime() - segmentCoreInfo.getStartTime()));
        this.segment.setStartTime(segmentCoreInfo.getStartTime());
        this.segment.setEndTime(segmentCoreInfo.getEndTime());
        this.segment.setIsError(BooleanUtils.booleanToValue((Boolean)segmentCoreInfo.isError()));
        this.segment.setTimeBucket(timeBucket);
        this.segment.setDataBinary(segmentCoreInfo.getDataBinary());
        this.segment.setVersion(segmentCoreInfo.isV2() ? 2 : 1);
        this.firstEndpointId = spanDecorator.getOperationNameId();
    }

    @Override
    public void parseEntry(SpanDecorator spanDecorator, SegmentCoreInfo segmentCoreInfo) {
        this.entryEndpointId = spanDecorator.getOperationNameId();
    }

    @Override
    public void parseGlobalTraceId(UniqueId uniqueId, SegmentCoreInfo segmentCoreInfo) {
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.UNKNOWN) || this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            this.sampleStatus = this.sampler.shouldSample(uniqueId) ? SAMPLE_STATUS.SAMPLED : SAMPLE_STATUS.IGNORE;
        }
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            return;
        }
        StringBuilder traceIdBuilder = new StringBuilder();
        for (int i = 0; i < uniqueId.getIdPartsList().size(); ++i) {
            if (i == 0) {
                traceIdBuilder.append(uniqueId.getIdPartsList().get(i));
                continue;
            }
            traceIdBuilder.append(".").append(uniqueId.getIdPartsList().get(i));
        }
        this.segment.setTraceId(traceIdBuilder.toString());
    }

    @Override
    public void build() {
        if (logger.isDebugEnabled()) {
            logger.debug("segment listener build, segment id: {}", (Object)this.segment.getSegmentId());
        }
        if (this.sampleStatus.equals((Object)SAMPLE_STATUS.IGNORE)) {
            return;
        }
        if (this.entryEndpointId == 0) {
            this.segment.setEndpointId(this.firstEndpointId);
            this.segment.setEndpointName(this.serviceNameCacheService.get(this.firstEndpointId).getName());
        } else {
            this.segment.setEndpointId(this.entryEndpointId);
            this.segment.setEndpointName(this.serviceNameCacheService.get(this.entryEndpointId).getName());
        }
        this.sourceReceiver.receive((Source)this.segment);
    }

    public static class Factory
    implements SpanListenerFactory {
        private TraceSegmentSampler sampler;

        public Factory(int segmentSamplingRate) {
            this.sampler = new TraceSegmentSampler(segmentSamplingRate);
        }

        @Override
        public SpanListener create(ModuleManager moduleManager, TraceServiceModuleConfig config) {
            return new SegmentSpanListener(moduleManager, this.sampler);
        }
    }

    private static enum SAMPLE_STATUS {
        UNKNOWN,
        SAMPLED,
        IGNORE;

    }
}

